/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * ModifyVolumeRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ModifyVolumeRequestMarshaller implements Marshaller<Request<ModifyVolumeRequest>, ModifyVolumeRequest> {

    public Request<ModifyVolumeRequest> marshall(ModifyVolumeRequest modifyVolumeRequest) {

        if (modifyVolumeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ModifyVolumeRequest> request = new DefaultRequest<ModifyVolumeRequest>(modifyVolumeRequest, "EC2Client");
        request.addParameter("Action", "ModifyVolume");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (modifyVolumeRequest.volumeId() != null) {
            request.addParameter("VolumeId", StringUtils.fromString(modifyVolumeRequest.volumeId()));
        }

        if (modifyVolumeRequest.size() != null) {
            request.addParameter("Size", StringUtils.fromInteger(modifyVolumeRequest.size()));
        }

        if (modifyVolumeRequest.volumeTypeString() != null) {
            request.addParameter("VolumeType", StringUtils.fromString(modifyVolumeRequest.volumeTypeString()));
        }

        if (modifyVolumeRequest.iops() != null) {
            request.addParameter("Iops", StringUtils.fromInteger(modifyVolumeRequest.iops()));
        }

        return request;
    }

}
