/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * ImportSnapshotRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ImportSnapshotRequestMarshaller implements Marshaller<Request<ImportSnapshotRequest>, ImportSnapshotRequest> {

    public Request<ImportSnapshotRequest> marshall(ImportSnapshotRequest importSnapshotRequest) {

        if (importSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ImportSnapshotRequest> request = new DefaultRequest<ImportSnapshotRequest>(importSnapshotRequest, "EC2Client");
        request.addParameter("Action", "ImportSnapshot");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        ClientData clientData = importSnapshotRequest.clientData();
        if (clientData != null) {

            if (clientData.comment() != null) {
                request.addParameter("ClientData.Comment", StringUtils.fromString(clientData.comment()));
            }

            if (clientData.uploadEnd() != null) {
                request.addParameter("ClientData.UploadEnd", StringUtils.fromInstant(clientData.uploadEnd()));
            }

            if (clientData.uploadSize() != null) {
                request.addParameter("ClientData.UploadSize", StringUtils.fromDouble(clientData.uploadSize()));
            }

            if (clientData.uploadStart() != null) {
                request.addParameter("ClientData.UploadStart", StringUtils.fromInstant(clientData.uploadStart()));
            }
        }

        if (importSnapshotRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(importSnapshotRequest.clientToken()));
        }

        if (importSnapshotRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString(importSnapshotRequest.description()));
        }

        SnapshotDiskContainer diskContainer = importSnapshotRequest.diskContainer();
        if (diskContainer != null) {

            if (diskContainer.description() != null) {
                request.addParameter("DiskContainer.Description", StringUtils.fromString(diskContainer.description()));
            }

            if (diskContainer.format() != null) {
                request.addParameter("DiskContainer.Format", StringUtils.fromString(diskContainer.format()));
            }

            if (diskContainer.url() != null) {
                request.addParameter("DiskContainer.Url", StringUtils.fromString(diskContainer.url()));
            }

            UserBucket userBucket = diskContainer.userBucket();
            if (userBucket != null) {

                if (userBucket.s3Bucket() != null) {
                    request.addParameter("DiskContainer.UserBucket.S3Bucket", StringUtils.fromString(userBucket.s3Bucket()));
                }

                if (userBucket.s3Key() != null) {
                    request.addParameter("DiskContainer.UserBucket.S3Key", StringUtils.fromString(userBucket.s3Key()));
                }
            }
        }

        if (importSnapshotRequest.roleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString(importSnapshotRequest.roleName()));
        }

        return request;
    }

}
