/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DescribeScheduledInstancesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeScheduledInstancesRequestMarshaller implements
        Marshaller<Request<DescribeScheduledInstancesRequest>, DescribeScheduledInstancesRequest> {

    public Request<DescribeScheduledInstancesRequest> marshall(DescribeScheduledInstancesRequest describeScheduledInstancesRequest) {

        if (describeScheduledInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeScheduledInstancesRequest> request = new DefaultRequest<DescribeScheduledInstancesRequest>(
                describeScheduledInstancesRequest, "EC2Client");
        request.addParameter("Action", "DescribeScheduledInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<Filter> describeScheduledInstancesRequestFiltersList = describeScheduledInstancesRequest.filters();
        if (describeScheduledInstancesRequestFiltersList != null) {
            int filtersListIndex = 1;

            for (Filter describeScheduledInstancesRequestFiltersListValue : describeScheduledInstancesRequestFiltersList) {

                if (describeScheduledInstancesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name",
                            StringUtils.fromString(describeScheduledInstancesRequestFiltersListValue.name()));
                }

                java.util.List<String> filterValuesList = describeScheduledInstancesRequestFiltersListValue.values();
                if (filterValuesList != null) {
                    int valuesListIndex = 1;

                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex,
                                    StringUtils.fromString(filterValuesListValue));
                        }
                        valuesListIndex++;
                    }
                }
                filtersListIndex++;
            }
        }

        if (describeScheduledInstancesRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeScheduledInstancesRequest.maxResults()));
        }

        if (describeScheduledInstancesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeScheduledInstancesRequest.nextToken()));
        }

        java.util.List<String> describeScheduledInstancesRequestScheduledInstanceIdsList = describeScheduledInstancesRequest
                .scheduledInstanceIds();
        if (describeScheduledInstancesRequestScheduledInstanceIdsList != null) {
            int scheduledInstanceIdsListIndex = 1;

            for (String describeScheduledInstancesRequestScheduledInstanceIdsListValue : describeScheduledInstancesRequestScheduledInstanceIdsList) {
                if (describeScheduledInstancesRequestScheduledInstanceIdsListValue != null) {
                    request.addParameter("ScheduledInstanceId." + scheduledInstanceIdsListIndex,
                            StringUtils.fromString(describeScheduledInstancesRequestScheduledInstanceIdsListValue));
                }
                scheduledInstanceIdsListIndex++;
            }
        }

        SlotStartTimeRangeRequest slotStartTimeRange = describeScheduledInstancesRequest.slotStartTimeRange();
        if (slotStartTimeRange != null) {

            if (slotStartTimeRange.earliestTime() != null) {
                request.addParameter("SlotStartTimeRange.EarliestTime",
                        StringUtils.fromInstant(slotStartTimeRange.earliestTime()));
            }

            if (slotStartTimeRange.latestTime() != null) {
                request.addParameter("SlotStartTimeRange.LatestTime", StringUtils.fromInstant(slotStartTimeRange.latestTime()));
            }
        }

        return request;
    }

}
