/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DescribeNetworkInterfacePermissionsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeNetworkInterfacePermissionsRequestMarshaller implements
        Marshaller<Request<DescribeNetworkInterfacePermissionsRequest>, DescribeNetworkInterfacePermissionsRequest> {

    public Request<DescribeNetworkInterfacePermissionsRequest> marshall(
            DescribeNetworkInterfacePermissionsRequest describeNetworkInterfacePermissionsRequest) {

        if (describeNetworkInterfacePermissionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeNetworkInterfacePermissionsRequest> request = new DefaultRequest<DescribeNetworkInterfacePermissionsRequest>(
                describeNetworkInterfacePermissionsRequest, "EC2Client");
        request.addParameter("Action", "DescribeNetworkInterfacePermissions");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<String> describeNetworkInterfacePermissionsRequestNetworkInterfacePermissionIdsList = describeNetworkInterfacePermissionsRequest
                .networkInterfacePermissionIds();
        if (describeNetworkInterfacePermissionsRequestNetworkInterfacePermissionIdsList != null) {
            int networkInterfacePermissionIdsListIndex = 1;

            for (String describeNetworkInterfacePermissionsRequestNetworkInterfacePermissionIdsListValue : describeNetworkInterfacePermissionsRequestNetworkInterfacePermissionIdsList) {
                if (describeNetworkInterfacePermissionsRequestNetworkInterfacePermissionIdsListValue != null) {
                    request.addParameter("NetworkInterfacePermissionId." + networkInterfacePermissionIdsListIndex, StringUtils
                            .fromString(describeNetworkInterfacePermissionsRequestNetworkInterfacePermissionIdsListValue));
                }
                networkInterfacePermissionIdsListIndex++;
            }
        }

        java.util.List<Filter> describeNetworkInterfacePermissionsRequestFiltersList = describeNetworkInterfacePermissionsRequest
                .filters();
        if (describeNetworkInterfacePermissionsRequestFiltersList != null) {
            int filtersListIndex = 1;

            for (Filter describeNetworkInterfacePermissionsRequestFiltersListValue : describeNetworkInterfacePermissionsRequestFiltersList) {

                if (describeNetworkInterfacePermissionsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name",
                            StringUtils.fromString(describeNetworkInterfacePermissionsRequestFiltersListValue.name()));
                }

                java.util.List<String> filterValuesList = describeNetworkInterfacePermissionsRequestFiltersListValue.values();
                if (filterValuesList != null) {
                    int valuesListIndex = 1;

                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex,
                                    StringUtils.fromString(filterValuesListValue));
                        }
                        valuesListIndex++;
                    }
                }
                filtersListIndex++;
            }
        }

        if (describeNetworkInterfacePermissionsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeNetworkInterfacePermissionsRequest.nextToken()));
        }

        if (describeNetworkInterfacePermissionsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeNetworkInterfacePermissionsRequest.maxResults()));
        }

        return request;
    }

}
