/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DescribeHostsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeHostsRequestMarshaller implements Marshaller<Request<DescribeHostsRequest>, DescribeHostsRequest> {

    public Request<DescribeHostsRequest> marshall(DescribeHostsRequest describeHostsRequest) {

        if (describeHostsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeHostsRequest> request = new DefaultRequest<DescribeHostsRequest>(describeHostsRequest, "EC2Client");
        request.addParameter("Action", "DescribeHosts");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<Filter> describeHostsRequestFilterList = describeHostsRequest.filter();
        if (describeHostsRequestFilterList != null) {
            int filterListIndex = 1;

            for (Filter describeHostsRequestFilterListValue : describeHostsRequestFilterList) {

                if (describeHostsRequestFilterListValue.name() != null) {
                    request.addParameter("Filter." + filterListIndex + ".Name",
                            StringUtils.fromString(describeHostsRequestFilterListValue.name()));
                }

                java.util.List<String> filterValuesList = describeHostsRequestFilterListValue.values();
                if (filterValuesList != null) {
                    int valuesListIndex = 1;

                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filterListIndex + ".Value." + valuesListIndex,
                                    StringUtils.fromString(filterValuesListValue));
                        }
                        valuesListIndex++;
                    }
                }
                filterListIndex++;
            }
        }

        java.util.List<String> describeHostsRequestHostIdsList = describeHostsRequest.hostIds();
        if (describeHostsRequestHostIdsList != null) {
            int hostIdsListIndex = 1;

            for (String describeHostsRequestHostIdsListValue : describeHostsRequestHostIdsList) {
                if (describeHostsRequestHostIdsListValue != null) {
                    request.addParameter("HostId." + hostIdsListIndex,
                            StringUtils.fromString(describeHostsRequestHostIdsListValue));
                }
                hostIdsListIndex++;
            }
        }

        if (describeHostsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeHostsRequest.maxResults()));
        }

        if (describeHostsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeHostsRequest.nextToken()));
        }

        return request;
    }

}
