/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * CreateVpcPeeringConnectionRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateVpcPeeringConnectionRequestMarshaller implements
        Marshaller<Request<CreateVpcPeeringConnectionRequest>, CreateVpcPeeringConnectionRequest> {

    public Request<CreateVpcPeeringConnectionRequest> marshall(CreateVpcPeeringConnectionRequest createVpcPeeringConnectionRequest) {

        if (createVpcPeeringConnectionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CreateVpcPeeringConnectionRequest> request = new DefaultRequest<CreateVpcPeeringConnectionRequest>(
                createVpcPeeringConnectionRequest, "EC2Client");
        request.addParameter("Action", "CreateVpcPeeringConnection");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (createVpcPeeringConnectionRequest.peerOwnerId() != null) {
            request.addParameter("PeerOwnerId", StringUtils.fromString(createVpcPeeringConnectionRequest.peerOwnerId()));
        }

        if (createVpcPeeringConnectionRequest.peerVpcId() != null) {
            request.addParameter("PeerVpcId", StringUtils.fromString(createVpcPeeringConnectionRequest.peerVpcId()));
        }

        if (createVpcPeeringConnectionRequest.vpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString(createVpcPeeringConnectionRequest.vpcId()));
        }

        return request;
    }

}
