/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * CreateInstanceExportTaskRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateInstanceExportTaskRequestMarshaller implements
        Marshaller<Request<CreateInstanceExportTaskRequest>, CreateInstanceExportTaskRequest> {

    public Request<CreateInstanceExportTaskRequest> marshall(CreateInstanceExportTaskRequest createInstanceExportTaskRequest) {

        if (createInstanceExportTaskRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CreateInstanceExportTaskRequest> request = new DefaultRequest<CreateInstanceExportTaskRequest>(
                createInstanceExportTaskRequest, "EC2Client");
        request.addParameter("Action", "CreateInstanceExportTask");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (createInstanceExportTaskRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString(createInstanceExportTaskRequest.description()));
        }

        ExportToS3TaskSpecification exportToS3Task = createInstanceExportTaskRequest.exportToS3Task();
        if (exportToS3Task != null) {

            if (exportToS3Task.containerFormatString() != null) {
                request.addParameter("ExportToS3.ContainerFormat", StringUtils.fromString(exportToS3Task.containerFormatString()));
            }

            if (exportToS3Task.diskImageFormatString() != null) {
                request.addParameter("ExportToS3.DiskImageFormat", StringUtils.fromString(exportToS3Task.diskImageFormatString()));
            }

            if (exportToS3Task.s3Bucket() != null) {
                request.addParameter("ExportToS3.S3Bucket", StringUtils.fromString(exportToS3Task.s3Bucket()));
            }

            if (exportToS3Task.s3Prefix() != null) {
                request.addParameter("ExportToS3.S3Prefix", StringUtils.fromString(exportToS3Task.s3Prefix()));
            }
        }

        if (createInstanceExportTaskRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(createInstanceExportTaskRequest.instanceId()));
        }

        if (createInstanceExportTaskRequest.targetEnvironmentString() != null) {
            request.addParameter("TargetEnvironment",
                    StringUtils.fromString(createInstanceExportTaskRequest.targetEnvironmentString()));
        }

        return request;
    }

}
