/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * AuthorizeSecurityGroupIngressRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AuthorizeSecurityGroupIngressRequestMarshaller implements
        Marshaller<Request<AuthorizeSecurityGroupIngressRequest>, AuthorizeSecurityGroupIngressRequest> {

    public Request<AuthorizeSecurityGroupIngressRequest> marshall(
            AuthorizeSecurityGroupIngressRequest authorizeSecurityGroupIngressRequest) {

        if (authorizeSecurityGroupIngressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<AuthorizeSecurityGroupIngressRequest> request = new DefaultRequest<AuthorizeSecurityGroupIngressRequest>(
                authorizeSecurityGroupIngressRequest, "EC2Client");
        request.addParameter("Action", "AuthorizeSecurityGroupIngress");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (authorizeSecurityGroupIngressRequest.cidrIp() != null) {
            request.addParameter("CidrIp", StringUtils.fromString(authorizeSecurityGroupIngressRequest.cidrIp()));
        }

        if (authorizeSecurityGroupIngressRequest.fromPort() != null) {
            request.addParameter("FromPort", StringUtils.fromInteger(authorizeSecurityGroupIngressRequest.fromPort()));
        }

        if (authorizeSecurityGroupIngressRequest.groupId() != null) {
            request.addParameter("GroupId", StringUtils.fromString(authorizeSecurityGroupIngressRequest.groupId()));
        }

        if (authorizeSecurityGroupIngressRequest.groupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString(authorizeSecurityGroupIngressRequest.groupName()));
        }

        java.util.List<IpPermission> authorizeSecurityGroupIngressRequestIpPermissionsList = authorizeSecurityGroupIngressRequest
                .ipPermissions();
        if (authorizeSecurityGroupIngressRequestIpPermissionsList != null) {
            int ipPermissionsListIndex = 1;

            for (IpPermission authorizeSecurityGroupIngressRequestIpPermissionsListValue : authorizeSecurityGroupIngressRequestIpPermissionsList) {

                if (authorizeSecurityGroupIngressRequestIpPermissionsListValue.fromPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".FromPort",
                            StringUtils.fromInteger(authorizeSecurityGroupIngressRequestIpPermissionsListValue.fromPort()));
                }

                if (authorizeSecurityGroupIngressRequestIpPermissionsListValue.ipProtocol() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpProtocol",
                            StringUtils.fromString(authorizeSecurityGroupIngressRequestIpPermissionsListValue.ipProtocol()));
                }

                java.util.List<Ipv6Range> ipPermissionIpv6RangesList = authorizeSecurityGroupIngressRequestIpPermissionsListValue
                        .ipv6Ranges();
                if (ipPermissionIpv6RangesList != null) {
                    int ipv6RangesListIndex = 1;

                    for (Ipv6Range ipPermissionIpv6RangesListValue : ipPermissionIpv6RangesList) {

                        if (ipPermissionIpv6RangesListValue.cidrIpv6() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Ipv6Ranges." + ipv6RangesListIndex
                                    + ".CidrIpv6", StringUtils.fromString(ipPermissionIpv6RangesListValue.cidrIpv6()));
                        }

                        if (ipPermissionIpv6RangesListValue.description() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Ipv6Ranges." + ipv6RangesListIndex
                                    + ".Description", StringUtils.fromString(ipPermissionIpv6RangesListValue.description()));
                        }
                        ipv6RangesListIndex++;
                    }
                }

                java.util.List<PrefixListId> ipPermissionPrefixListIdsList = authorizeSecurityGroupIngressRequestIpPermissionsListValue
                        .prefixListIds();
                if (ipPermissionPrefixListIdsList != null) {
                    int prefixListIdsListIndex = 1;

                    for (PrefixListId ipPermissionPrefixListIdsListValue : ipPermissionPrefixListIdsList) {

                        if (ipPermissionPrefixListIdsListValue.description() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".PrefixListIds."
                                    + prefixListIdsListIndex + ".Description",
                                    StringUtils.fromString(ipPermissionPrefixListIdsListValue.description()));
                        }

                        if (ipPermissionPrefixListIdsListValue.prefixListId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".PrefixListIds."
                                    + prefixListIdsListIndex + ".PrefixListId",
                                    StringUtils.fromString(ipPermissionPrefixListIdsListValue.prefixListId()));
                        }
                        prefixListIdsListIndex++;
                    }
                }

                if (authorizeSecurityGroupIngressRequestIpPermissionsListValue.toPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".ToPort",
                            StringUtils.fromInteger(authorizeSecurityGroupIngressRequestIpPermissionsListValue.toPort()));
                }

                java.util.List<UserIdGroupPair> ipPermissionUserIdGroupPairsList = authorizeSecurityGroupIngressRequestIpPermissionsListValue
                        .userIdGroupPairs();
                if (ipPermissionUserIdGroupPairsList != null) {
                    int userIdGroupPairsListIndex = 1;

                    for (UserIdGroupPair ipPermissionUserIdGroupPairsListValue : ipPermissionUserIdGroupPairsList) {

                        if (ipPermissionUserIdGroupPairsListValue.description() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups."
                                    + userIdGroupPairsListIndex + ".Description",
                                    StringUtils.fromString(ipPermissionUserIdGroupPairsListValue.description()));
                        }

                        if (ipPermissionUserIdGroupPairsListValue.groupId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups."
                                    + userIdGroupPairsListIndex + ".GroupId",
                                    StringUtils.fromString(ipPermissionUserIdGroupPairsListValue.groupId()));
                        }

                        if (ipPermissionUserIdGroupPairsListValue.groupName() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups."
                                    + userIdGroupPairsListIndex + ".GroupName",
                                    StringUtils.fromString(ipPermissionUserIdGroupPairsListValue.groupName()));
                        }

                        if (ipPermissionUserIdGroupPairsListValue.peeringStatus() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups."
                                    + userIdGroupPairsListIndex + ".PeeringStatus",
                                    StringUtils.fromString(ipPermissionUserIdGroupPairsListValue.peeringStatus()));
                        }

                        if (ipPermissionUserIdGroupPairsListValue.userId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups."
                                    + userIdGroupPairsListIndex + ".UserId",
                                    StringUtils.fromString(ipPermissionUserIdGroupPairsListValue.userId()));
                        }

                        if (ipPermissionUserIdGroupPairsListValue.vpcId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups."
                                    + userIdGroupPairsListIndex + ".VpcId",
                                    StringUtils.fromString(ipPermissionUserIdGroupPairsListValue.vpcId()));
                        }

                        if (ipPermissionUserIdGroupPairsListValue.vpcPeeringConnectionId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups."
                                    + userIdGroupPairsListIndex + ".VpcPeeringConnectionId",
                                    StringUtils.fromString(ipPermissionUserIdGroupPairsListValue.vpcPeeringConnectionId()));
                        }
                        userIdGroupPairsListIndex++;
                    }
                }

                java.util.List<IpRange> ipPermissionIpv4RangesList = authorizeSecurityGroupIngressRequestIpPermissionsListValue
                        .ipv4Ranges();
                if (ipPermissionIpv4RangesList != null) {
                    int ipv4RangesListIndex = 1;

                    for (IpRange ipPermissionIpv4RangesListValue : ipPermissionIpv4RangesList) {

                        if (ipPermissionIpv4RangesListValue.cidrIp() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpRanges." + ipv4RangesListIndex
                                    + ".CidrIp", StringUtils.fromString(ipPermissionIpv4RangesListValue.cidrIp()));
                        }

                        if (ipPermissionIpv4RangesListValue.description() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpRanges." + ipv4RangesListIndex
                                    + ".Description", StringUtils.fromString(ipPermissionIpv4RangesListValue.description()));
                        }
                        ipv4RangesListIndex++;
                    }
                }
                ipPermissionsListIndex++;
            }
        }

        if (authorizeSecurityGroupIngressRequest.ipProtocol() != null) {
            request.addParameter("IpProtocol", StringUtils.fromString(authorizeSecurityGroupIngressRequest.ipProtocol()));
        }

        if (authorizeSecurityGroupIngressRequest.sourceSecurityGroupName() != null) {
            request.addParameter("SourceSecurityGroupName",
                    StringUtils.fromString(authorizeSecurityGroupIngressRequest.sourceSecurityGroupName()));
        }

        if (authorizeSecurityGroupIngressRequest.sourceSecurityGroupOwnerId() != null) {
            request.addParameter("SourceSecurityGroupOwnerId",
                    StringUtils.fromString(authorizeSecurityGroupIngressRequest.sourceSecurityGroupOwnerId()));
        }

        if (authorizeSecurityGroupIngressRequest.toPort() != null) {
            request.addParameter("ToPort", StringUtils.fromInteger(authorizeSecurityGroupIngressRequest.toPort()));
        }

        return request;
    }

}
