/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for UpdateSecurityGroupRuleDescriptionsIngress.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateSecurityGroupRuleDescriptionsIngressRequest extends AmazonWebServiceRequest
        implements
        ToCopyableBuilder<UpdateSecurityGroupRuleDescriptionsIngressRequest.Builder, UpdateSecurityGroupRuleDescriptionsIngressRequest> {
    private final String groupId;

    private final String groupName;

    private final List<IpPermission> ipPermissions;

    private UpdateSecurityGroupRuleDescriptionsIngressRequest(BuilderImpl builder) {
        this.groupId = builder.groupId;
        this.groupName = builder.groupName;
        this.ipPermissions = builder.ipPermissions;
    }

    /**
     * <p>
     * The ID of the security group. You must specify either the security group ID or the security group name in the
     * request. For security groups in a nondefault VPC, you must specify the security group ID.
     * </p>
     * 
     * @return The ID of the security group. You must specify either the security group ID or the security group name in
     *         the request. For security groups in a nondefault VPC, you must specify the security group ID.
     */
    public String groupId() {
        return groupId;
    }

    /**
     * <p>
     * [EC2-Classic, default VPC] The name of the security group. You must specify either the security group ID or the
     * security group name in the request.
     * </p>
     * 
     * @return [EC2-Classic, default VPC] The name of the security group. You must specify either the security group ID
     *         or the security group name in the request.
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The IP permissions for the security group rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IP permissions for the security group rule.
     */
    public List<IpPermission> ipPermissions() {
        return ipPermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(ipPermissions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityGroupRuleDescriptionsIngressRequest)) {
            return false;
        }
        UpdateSecurityGroupRuleDescriptionsIngressRequest other = (UpdateSecurityGroupRuleDescriptionsIngressRequest) obj;
        return Objects.equals(groupId(), other.groupId()) && Objects.equals(groupName(), other.groupName())
                && Objects.equals(ipPermissions(), other.ipPermissions());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (groupId() != null) {
            sb.append("GroupId: ").append(groupId()).append(",");
        }
        if (groupName() != null) {
            sb.append("GroupName: ").append(groupName()).append(",");
        }
        if (ipPermissions() != null) {
            sb.append("IpPermissions: ").append(ipPermissions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupId":
            return Optional.of(clazz.cast(groupId()));
        case "GroupName":
            return Optional.of(clazz.cast(groupName()));
        case "IpPermissions":
            return Optional.of(clazz.cast(ipPermissions()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateSecurityGroupRuleDescriptionsIngressRequest> {
        /**
         * <p>
         * The ID of the security group. You must specify either the security group ID or the security group name in the
         * request. For security groups in a nondefault VPC, you must specify the security group ID.
         * </p>
         * 
         * @param groupId
         *        The ID of the security group. You must specify either the security group ID or the security group name
         *        in the request. For security groups in a nondefault VPC, you must specify the security group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * [EC2-Classic, default VPC] The name of the security group. You must specify either the security group ID or
         * the security group name in the request.
         * </p>
         * 
         * @param groupName
         *        [EC2-Classic, default VPC] The name of the security group. You must specify either the security group
         *        ID or the security group name in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The IP permissions for the security group rule.
         * </p>
         * 
         * @param ipPermissions
         *        The IP permissions for the security group rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissions(Collection<IpPermission> ipPermissions);

        /**
         * <p>
         * The IP permissions for the security group rule.
         * </p>
         * 
         * @param ipPermissions
         *        The IP permissions for the security group rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissions(IpPermission... ipPermissions);
    }

    static final class BuilderImpl implements Builder {
        private String groupId;

        private String groupName;

        private List<IpPermission> ipPermissions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecurityGroupRuleDescriptionsIngressRequest model) {
            groupId(model.groupId);
            groupName(model.groupName);
            ipPermissions(model.ipPermissions);
        }

        public final String getGroupId() {
            return groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final Collection<IpPermission.Builder> getIpPermissions() {
            return ipPermissions != null ? ipPermissions.stream().map(IpPermission::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder ipPermissions(Collection<IpPermission> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copy(ipPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(IpPermission... ipPermissions) {
            ipPermissions(Arrays.asList(ipPermissions));
            return this;
        }

        public final void setIpPermissions(Collection<IpPermission.BuilderImpl> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copyFromBuilder(ipPermissions);
        }

        @Override
        public UpdateSecurityGroupRuleDescriptionsIngressRequest build() {
            return new UpdateSecurityGroupRuleDescriptionsIngressRequest(this);
        }
    }
}
