/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The tags to apply to a resource when the resource is being created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TagSpecification implements ToCopyableBuilder<TagSpecification.Builder, TagSpecification> {
    private final String resourceType;

    private final List<Tag> tags;

    private TagSpecification(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The type of resource to tag. Currently, the resource types that support tagging on creation are
     * <code>instance</code> and <code>volume</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeString}.
     * </p>
     * 
     * @return The type of resource to tag. Currently, the resource types that support tagging on creation are
     *         <code>instance</code> and <code>volume</code>.
     * @see ResourceType
     */
    public ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource to tag. Currently, the resource types that support tagging on creation are
     * <code>instance</code> and <code>volume</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeString}.
     * </p>
     * 
     * @return The type of resource to tag. Currently, the resource types that support tagging on creation are
     *         <code>instance</code> and <code>volume</code>.
     * @see ResourceType
     */
    public String resourceTypeString() {
        return resourceType;
    }

    /**
     * <p>
     * The tags to apply to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tags to apply to the resource.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagSpecification)) {
            return false;
        }
        TagSpecification other = (TagSpecification) obj;
        return Objects.equals(resourceTypeString(), other.resourceTypeString()) && Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (resourceTypeString() != null) {
            sb.append("ResourceType: ").append(resourceTypeString()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceType":
            return Optional.of(clazz.cast(resourceTypeString()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, TagSpecification> {
        /**
         * <p>
         * The type of resource to tag. Currently, the resource types that support tagging on creation are
         * <code>instance</code> and <code>volume</code>.
         * </p>
         * 
         * @param resourceType
         *        The type of resource to tag. Currently, the resource types that support tagging on creation are
         *        <code>instance</code> and <code>volume</code>.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource to tag. Currently, the resource types that support tagging on creation are
         * <code>instance</code> and <code>volume</code>.
         * </p>
         * 
         * @param resourceType
         *        The type of resource to tag. Currently, the resource types that support tagging on creation are
         *        <code>instance</code> and <code>volume</code>.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The tags to apply to the resource.
         * </p>
         * 
         * @param tags
         *        The tags to apply to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to apply to the resource.
         * </p>
         * 
         * @param tags
         *        The tags to apply to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);
    }

    static final class BuilderImpl implements Builder {
        private String resourceType;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(TagSpecification model) {
            resourceType(model.resourceType);
            tags(model.tags);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public TagSpecification build() {
            return new TagSpecification(this);
        }
    }
}
