/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a schedule that is available for your Scheduled Instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ScheduledInstanceAvailability implements
        ToCopyableBuilder<ScheduledInstanceAvailability.Builder, ScheduledInstanceAvailability> {
    private final String availabilityZone;

    private final Integer availableInstanceCount;

    private final Instant firstSlotStartTime;

    private final String hourlyPrice;

    private final String instanceType;

    private final Integer maxTermDurationInDays;

    private final Integer minTermDurationInDays;

    private final String networkPlatform;

    private final String platform;

    private final String purchaseToken;

    private final ScheduledInstanceRecurrence recurrence;

    private final Integer slotDurationInHours;

    private final Integer totalScheduledInstanceHours;

    private ScheduledInstanceAvailability(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.availableInstanceCount = builder.availableInstanceCount;
        this.firstSlotStartTime = builder.firstSlotStartTime;
        this.hourlyPrice = builder.hourlyPrice;
        this.instanceType = builder.instanceType;
        this.maxTermDurationInDays = builder.maxTermDurationInDays;
        this.minTermDurationInDays = builder.minTermDurationInDays;
        this.networkPlatform = builder.networkPlatform;
        this.platform = builder.platform;
        this.purchaseToken = builder.purchaseToken;
        this.recurrence = builder.recurrence;
        this.slotDurationInHours = builder.slotDurationInHours;
        this.totalScheduledInstanceHours = builder.totalScheduledInstanceHours;
    }

    /**
     * <p>
     * The Availability Zone.
     * </p>
     * 
     * @return The Availability Zone.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The number of available instances.
     * </p>
     * 
     * @return The number of available instances.
     */
    public Integer availableInstanceCount() {
        return availableInstanceCount;
    }

    /**
     * <p>
     * The time period for the first schedule to start.
     * </p>
     * 
     * @return The time period for the first schedule to start.
     */
    public Instant firstSlotStartTime() {
        return firstSlotStartTime;
    }

    /**
     * <p>
     * The hourly price for a single instance.
     * </p>
     * 
     * @return The hourly price for a single instance.
     */
    public String hourlyPrice() {
        return hourlyPrice;
    }

    /**
     * <p>
     * The instance type. You can specify one of the C3, C4, M4, or R3 instance types.
     * </p>
     * 
     * @return The instance type. You can specify one of the C3, C4, M4, or R3 instance types.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The maximum term. The only possible value is 365 days.
     * </p>
     * 
     * @return The maximum term. The only possible value is 365 days.
     */
    public Integer maxTermDurationInDays() {
        return maxTermDurationInDays;
    }

    /**
     * <p>
     * The minimum term. The only possible value is 365 days.
     * </p>
     * 
     * @return The minimum term. The only possible value is 365 days.
     */
    public Integer minTermDurationInDays() {
        return minTermDurationInDays;
    }

    /**
     * <p>
     * The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
     * </p>
     * 
     * @return The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
     */
    public String networkPlatform() {
        return networkPlatform;
    }

    /**
     * <p>
     * The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
     * </p>
     * 
     * @return The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
     */
    public String platform() {
        return platform;
    }

    /**
     * <p>
     * The purchase token. This token expires in two hours.
     * </p>
     * 
     * @return The purchase token. This token expires in two hours.
     */
    public String purchaseToken() {
        return purchaseToken;
    }

    /**
     * <p>
     * The schedule recurrence.
     * </p>
     * 
     * @return The schedule recurrence.
     */
    public ScheduledInstanceRecurrence recurrence() {
        return recurrence;
    }

    /**
     * <p>
     * The number of hours in the schedule.
     * </p>
     * 
     * @return The number of hours in the schedule.
     */
    public Integer slotDurationInHours() {
        return slotDurationInHours;
    }

    /**
     * <p>
     * The total number of hours for a single instance for the entire term.
     * </p>
     * 
     * @return The total number of hours for a single instance for the entire term.
     */
    public Integer totalScheduledInstanceHours() {
        return totalScheduledInstanceHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(availableInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(firstSlotStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(hourlyPrice());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(maxTermDurationInDays());
        hashCode = 31 * hashCode + Objects.hashCode(minTermDurationInDays());
        hashCode = 31 * hashCode + Objects.hashCode(networkPlatform());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(purchaseToken());
        hashCode = 31 * hashCode + Objects.hashCode(recurrence());
        hashCode = 31 * hashCode + Objects.hashCode(slotDurationInHours());
        hashCode = 31 * hashCode + Objects.hashCode(totalScheduledInstanceHours());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstanceAvailability)) {
            return false;
        }
        ScheduledInstanceAvailability other = (ScheduledInstanceAvailability) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(availableInstanceCount(), other.availableInstanceCount())
                && Objects.equals(firstSlotStartTime(), other.firstSlotStartTime())
                && Objects.equals(hourlyPrice(), other.hourlyPrice()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(maxTermDurationInDays(), other.maxTermDurationInDays())
                && Objects.equals(minTermDurationInDays(), other.minTermDurationInDays())
                && Objects.equals(networkPlatform(), other.networkPlatform()) && Objects.equals(platform(), other.platform())
                && Objects.equals(purchaseToken(), other.purchaseToken()) && Objects.equals(recurrence(), other.recurrence())
                && Objects.equals(slotDurationInHours(), other.slotDurationInHours())
                && Objects.equals(totalScheduledInstanceHours(), other.totalScheduledInstanceHours());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (availableInstanceCount() != null) {
            sb.append("AvailableInstanceCount: ").append(availableInstanceCount()).append(",");
        }
        if (firstSlotStartTime() != null) {
            sb.append("FirstSlotStartTime: ").append(firstSlotStartTime()).append(",");
        }
        if (hourlyPrice() != null) {
            sb.append("HourlyPrice: ").append(hourlyPrice()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (maxTermDurationInDays() != null) {
            sb.append("MaxTermDurationInDays: ").append(maxTermDurationInDays()).append(",");
        }
        if (minTermDurationInDays() != null) {
            sb.append("MinTermDurationInDays: ").append(minTermDurationInDays()).append(",");
        }
        if (networkPlatform() != null) {
            sb.append("NetworkPlatform: ").append(networkPlatform()).append(",");
        }
        if (platform() != null) {
            sb.append("Platform: ").append(platform()).append(",");
        }
        if (purchaseToken() != null) {
            sb.append("PurchaseToken: ").append(purchaseToken()).append(",");
        }
        if (recurrence() != null) {
            sb.append("Recurrence: ").append(recurrence()).append(",");
        }
        if (slotDurationInHours() != null) {
            sb.append("SlotDurationInHours: ").append(slotDurationInHours()).append(",");
        }
        if (totalScheduledInstanceHours() != null) {
            sb.append("TotalScheduledInstanceHours: ").append(totalScheduledInstanceHours()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.of(clazz.cast(availabilityZone()));
        case "AvailableInstanceCount":
            return Optional.of(clazz.cast(availableInstanceCount()));
        case "FirstSlotStartTime":
            return Optional.of(clazz.cast(firstSlotStartTime()));
        case "HourlyPrice":
            return Optional.of(clazz.cast(hourlyPrice()));
        case "InstanceType":
            return Optional.of(clazz.cast(instanceType()));
        case "MaxTermDurationInDays":
            return Optional.of(clazz.cast(maxTermDurationInDays()));
        case "MinTermDurationInDays":
            return Optional.of(clazz.cast(minTermDurationInDays()));
        case "NetworkPlatform":
            return Optional.of(clazz.cast(networkPlatform()));
        case "Platform":
            return Optional.of(clazz.cast(platform()));
        case "PurchaseToken":
            return Optional.of(clazz.cast(purchaseToken()));
        case "Recurrence":
            return Optional.of(clazz.cast(recurrence()));
        case "SlotDurationInHours":
            return Optional.of(clazz.cast(slotDurationInHours()));
        case "TotalScheduledInstanceHours":
            return Optional.of(clazz.cast(totalScheduledInstanceHours()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ScheduledInstanceAvailability> {
        /**
         * <p>
         * The Availability Zone.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The number of available instances.
         * </p>
         * 
         * @param availableInstanceCount
         *        The number of available instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableInstanceCount(Integer availableInstanceCount);

        /**
         * <p>
         * The time period for the first schedule to start.
         * </p>
         * 
         * @param firstSlotStartTime
         *        The time period for the first schedule to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstSlotStartTime(Instant firstSlotStartTime);

        /**
         * <p>
         * The hourly price for a single instance.
         * </p>
         * 
         * @param hourlyPrice
         *        The hourly price for a single instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourlyPrice(String hourlyPrice);

        /**
         * <p>
         * The instance type. You can specify one of the C3, C4, M4, or R3 instance types.
         * </p>
         * 
         * @param instanceType
         *        The instance type. You can specify one of the C3, C4, M4, or R3 instance types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The maximum term. The only possible value is 365 days.
         * </p>
         * 
         * @param maxTermDurationInDays
         *        The maximum term. The only possible value is 365 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxTermDurationInDays(Integer maxTermDurationInDays);

        /**
         * <p>
         * The minimum term. The only possible value is 365 days.
         * </p>
         * 
         * @param minTermDurationInDays
         *        The minimum term. The only possible value is 365 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minTermDurationInDays(Integer minTermDurationInDays);

        /**
         * <p>
         * The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
         * </p>
         * 
         * @param networkPlatform
         *        The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkPlatform(String networkPlatform);

        /**
         * <p>
         * The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         * </p>
         * 
         * @param platform
         *        The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The purchase token. This token expires in two hours.
         * </p>
         * 
         * @param purchaseToken
         *        The purchase token. This token expires in two hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchaseToken(String purchaseToken);

        /**
         * <p>
         * The schedule recurrence.
         * </p>
         * 
         * @param recurrence
         *        The schedule recurrence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurrence(ScheduledInstanceRecurrence recurrence);

        /**
         * <p>
         * The schedule recurrence.
         * </p>
         * This is a convenience that creates an instance of the {@link ScheduledInstanceRecurrence.Builder} avoiding
         * the need to create one manually via {@link ScheduledInstanceRecurrence#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScheduledInstanceRecurrence.Builder#build()} is called
         * immediately and its result is passed to {@link #recurrence(ScheduledInstanceRecurrence)}.
         * 
         * @param recurrence
         *        a consumer that will call methods on {@link ScheduledInstanceRecurrence.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recurrence(ScheduledInstanceRecurrence)
         */
        default Builder recurrence(Consumer<ScheduledInstanceRecurrence.Builder> recurrence) {
            return recurrence(ScheduledInstanceRecurrence.builder().apply(recurrence).build());
        }

        /**
         * <p>
         * The number of hours in the schedule.
         * </p>
         * 
         * @param slotDurationInHours
         *        The number of hours in the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotDurationInHours(Integer slotDurationInHours);

        /**
         * <p>
         * The total number of hours for a single instance for the entire term.
         * </p>
         * 
         * @param totalScheduledInstanceHours
         *        The total number of hours for a single instance for the entire term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalScheduledInstanceHours(Integer totalScheduledInstanceHours);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private Integer availableInstanceCount;

        private Instant firstSlotStartTime;

        private String hourlyPrice;

        private String instanceType;

        private Integer maxTermDurationInDays;

        private Integer minTermDurationInDays;

        private String networkPlatform;

        private String platform;

        private String purchaseToken;

        private ScheduledInstanceRecurrence recurrence;

        private Integer slotDurationInHours;

        private Integer totalScheduledInstanceHours;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstanceAvailability model) {
            availabilityZone(model.availabilityZone);
            availableInstanceCount(model.availableInstanceCount);
            firstSlotStartTime(model.firstSlotStartTime);
            hourlyPrice(model.hourlyPrice);
            instanceType(model.instanceType);
            maxTermDurationInDays(model.maxTermDurationInDays);
            minTermDurationInDays(model.minTermDurationInDays);
            networkPlatform(model.networkPlatform);
            platform(model.platform);
            purchaseToken(model.purchaseToken);
            recurrence(model.recurrence);
            slotDurationInHours(model.slotDurationInHours);
            totalScheduledInstanceHours(model.totalScheduledInstanceHours);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Integer getAvailableInstanceCount() {
            return availableInstanceCount;
        }

        @Override
        public final Builder availableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
            return this;
        }

        public final void setAvailableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
        }

        public final Instant getFirstSlotStartTime() {
            return firstSlotStartTime;
        }

        @Override
        public final Builder firstSlotStartTime(Instant firstSlotStartTime) {
            this.firstSlotStartTime = firstSlotStartTime;
            return this;
        }

        public final void setFirstSlotStartTime(Instant firstSlotStartTime) {
            this.firstSlotStartTime = firstSlotStartTime;
        }

        public final String getHourlyPrice() {
            return hourlyPrice;
        }

        @Override
        public final Builder hourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
            return this;
        }

        public final void setHourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getMaxTermDurationInDays() {
            return maxTermDurationInDays;
        }

        @Override
        public final Builder maxTermDurationInDays(Integer maxTermDurationInDays) {
            this.maxTermDurationInDays = maxTermDurationInDays;
            return this;
        }

        public final void setMaxTermDurationInDays(Integer maxTermDurationInDays) {
            this.maxTermDurationInDays = maxTermDurationInDays;
        }

        public final Integer getMinTermDurationInDays() {
            return minTermDurationInDays;
        }

        @Override
        public final Builder minTermDurationInDays(Integer minTermDurationInDays) {
            this.minTermDurationInDays = minTermDurationInDays;
            return this;
        }

        public final void setMinTermDurationInDays(Integer minTermDurationInDays) {
            this.minTermDurationInDays = minTermDurationInDays;
        }

        public final String getNetworkPlatform() {
            return networkPlatform;
        }

        @Override
        public final Builder networkPlatform(String networkPlatform) {
            this.networkPlatform = networkPlatform;
            return this;
        }

        public final void setNetworkPlatform(String networkPlatform) {
            this.networkPlatform = networkPlatform;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getPurchaseToken() {
            return purchaseToken;
        }

        @Override
        public final Builder purchaseToken(String purchaseToken) {
            this.purchaseToken = purchaseToken;
            return this;
        }

        public final void setPurchaseToken(String purchaseToken) {
            this.purchaseToken = purchaseToken;
        }

        public final ScheduledInstanceRecurrence.Builder getRecurrence() {
            return recurrence != null ? recurrence.toBuilder() : null;
        }

        @Override
        public final Builder recurrence(ScheduledInstanceRecurrence recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public final void setRecurrence(ScheduledInstanceRecurrence.BuilderImpl recurrence) {
            this.recurrence = recurrence != null ? recurrence.build() : null;
        }

        public final Integer getSlotDurationInHours() {
            return slotDurationInHours;
        }

        @Override
        public final Builder slotDurationInHours(Integer slotDurationInHours) {
            this.slotDurationInHours = slotDurationInHours;
            return this;
        }

        public final void setSlotDurationInHours(Integer slotDurationInHours) {
            this.slotDurationInHours = slotDurationInHours;
        }

        public final Integer getTotalScheduledInstanceHours() {
            return totalScheduledInstanceHours;
        }

        @Override
        public final Builder totalScheduledInstanceHours(Integer totalScheduledInstanceHours) {
            this.totalScheduledInstanceHours = totalScheduledInstanceHours;
            return this;
        }

        public final void setTotalScheduledInstanceHours(Integer totalScheduledInstanceHours) {
            this.totalScheduledInstanceHours = totalScheduledInstanceHours;
        }

        @Override
        public ScheduledInstanceAvailability build() {
            return new ScheduledInstanceAvailability(this);
        }
    }
}
