/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for RunScheduledInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RunScheduledInstancesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RunScheduledInstancesRequest.Builder, RunScheduledInstancesRequest> {
    private final String clientToken;

    private final Integer instanceCount;

    private final ScheduledInstancesLaunchSpecification launchSpecification;

    private final String scheduledInstanceId;

    private RunScheduledInstancesRequest(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.instanceCount = builder.instanceCount;
        this.launchSpecification = builder.launchSpecification;
        this.scheduledInstanceId = builder.scheduledInstanceId;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that ensures the idempotency of the request. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that ensures the idempotency of the request. For more information, see
     *         <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The number of instances.
     * </p>
     * <p>
     * Default: 1
     * </p>
     * 
     * @return The number of instances.</p>
     *         <p>
     *         Default: 1
     */
    public Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The launch specification. You must match the instance type, Availability Zone, network, and platform of the
     * schedule that you purchased.
     * </p>
     * 
     * @return The launch specification. You must match the instance type, Availability Zone, network, and platform of
     *         the schedule that you purchased.
     */
    public ScheduledInstancesLaunchSpecification launchSpecification() {
        return launchSpecification;
    }

    /**
     * <p>
     * The Scheduled Instance ID.
     * </p>
     * 
     * @return The Scheduled Instance ID.
     */
    public String scheduledInstanceId() {
        return scheduledInstanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(launchSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledInstanceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunScheduledInstancesRequest)) {
            return false;
        }
        RunScheduledInstancesRequest other = (RunScheduledInstancesRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(launchSpecification(), other.launchSpecification())
                && Objects.equals(scheduledInstanceId(), other.scheduledInstanceId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (clientToken() != null) {
            sb.append("ClientToken: ").append(clientToken()).append(",");
        }
        if (instanceCount() != null) {
            sb.append("InstanceCount: ").append(instanceCount()).append(",");
        }
        if (launchSpecification() != null) {
            sb.append("LaunchSpecification: ").append(launchSpecification()).append(",");
        }
        if (scheduledInstanceId() != null) {
            sb.append("ScheduledInstanceId: ").append(scheduledInstanceId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        case "InstanceCount":
            return Optional.of(clazz.cast(instanceCount()));
        case "LaunchSpecification":
            return Optional.of(clazz.cast(launchSpecification()));
        case "ScheduledInstanceId":
            return Optional.of(clazz.cast(scheduledInstanceId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, RunScheduledInstancesRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that ensures the idempotency of the request. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that ensures the idempotency of the request. For more information,
         *        see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The number of instances.
         * </p>
         * <p>
         * Default: 1
         * </p>
         * 
         * @param instanceCount
         *        The number of instances.</p>
         *        <p>
         *        Default: 1
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The launch specification. You must match the instance type, Availability Zone, network, and platform of the
         * schedule that you purchased.
         * </p>
         * 
         * @param launchSpecification
         *        The launch specification. You must match the instance type, Availability Zone, network, and platform
         *        of the schedule that you purchased.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchSpecification(ScheduledInstancesLaunchSpecification launchSpecification);

        /**
         * <p>
         * The launch specification. You must match the instance type, Availability Zone, network, and platform of the
         * schedule that you purchased.
         * </p>
         * This is a convenience that creates an instance of the {@link ScheduledInstancesLaunchSpecification.Builder}
         * avoiding the need to create one manually via {@link ScheduledInstancesLaunchSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScheduledInstancesLaunchSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #launchSpecification(ScheduledInstancesLaunchSpecification)}.
         * 
         * @param launchSpecification
         *        a consumer that will call methods on {@link ScheduledInstancesLaunchSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchSpecification(ScheduledInstancesLaunchSpecification)
         */
        default Builder launchSpecification(Consumer<ScheduledInstancesLaunchSpecification.Builder> launchSpecification) {
            return launchSpecification(ScheduledInstancesLaunchSpecification.builder().apply(launchSpecification).build());
        }

        /**
         * <p>
         * The Scheduled Instance ID.
         * </p>
         * 
         * @param scheduledInstanceId
         *        The Scheduled Instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledInstanceId(String scheduledInstanceId);
    }

    static final class BuilderImpl implements Builder {
        private String clientToken;

        private Integer instanceCount;

        private ScheduledInstancesLaunchSpecification launchSpecification;

        private String scheduledInstanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(RunScheduledInstancesRequest model) {
            clientToken(model.clientToken);
            instanceCount(model.instanceCount);
            launchSpecification(model.launchSpecification);
            scheduledInstanceId(model.scheduledInstanceId);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final ScheduledInstancesLaunchSpecification.Builder getLaunchSpecification() {
            return launchSpecification != null ? launchSpecification.toBuilder() : null;
        }

        @Override
        public final Builder launchSpecification(ScheduledInstancesLaunchSpecification launchSpecification) {
            this.launchSpecification = launchSpecification;
            return this;
        }

        public final void setLaunchSpecification(ScheduledInstancesLaunchSpecification.BuilderImpl launchSpecification) {
            this.launchSpecification = launchSpecification != null ? launchSpecification.build() : null;
        }

        public final String getScheduledInstanceId() {
            return scheduledInstanceId;
        }

        @Override
        public final Builder scheduledInstanceId(String scheduledInstanceId) {
            this.scheduledInstanceId = scheduledInstanceId;
            return this;
        }

        public final void setScheduledInstanceId(String scheduledInstanceId) {
            this.scheduledInstanceId = scheduledInstanceId;
        }

        @Override
        public RunScheduledInstancesRequest build() {
            return new RunScheduledInstancesRequest(this);
        }
    }
}
