/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ResetNetworkInterfaceAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ResetNetworkInterfaceAttributeRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ResetNetworkInterfaceAttributeRequest.Builder, ResetNetworkInterfaceAttributeRequest> {
    private final String networkInterfaceId;

    private final String sourceDestCheck;

    private ResetNetworkInterfaceAttributeRequest(BuilderImpl builder) {
        this.networkInterfaceId = builder.networkInterfaceId;
        this.sourceDestCheck = builder.sourceDestCheck;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The source/destination checking attribute. Resets the value to <code>true</code>.
     * </p>
     * 
     * @return The source/destination checking attribute. Resets the value to <code>true</code>.
     */
    public String sourceDestCheck() {
        return sourceDestCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDestCheck());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetNetworkInterfaceAttributeRequest)) {
            return false;
        }
        ResetNetworkInterfaceAttributeRequest other = (ResetNetworkInterfaceAttributeRequest) obj;
        return Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(sourceDestCheck(), other.sourceDestCheck());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(networkInterfaceId()).append(",");
        }
        if (sourceDestCheck() != null) {
            sb.append("SourceDestCheck: ").append(sourceDestCheck()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInterfaceId":
            return Optional.of(clazz.cast(networkInterfaceId()));
        case "SourceDestCheck":
            return Optional.of(clazz.cast(sourceDestCheck()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ResetNetworkInterfaceAttributeRequest> {
        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The source/destination checking attribute. Resets the value to <code>true</code>.
         * </p>
         * 
         * @param sourceDestCheck
         *        The source/destination checking attribute. Resets the value to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDestCheck(String sourceDestCheck);
    }

    static final class BuilderImpl implements Builder {
        private String networkInterfaceId;

        private String sourceDestCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetNetworkInterfaceAttributeRequest model) {
            networkInterfaceId(model.networkInterfaceId);
            sourceDestCheck(model.sourceDestCheck);
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getSourceDestCheck() {
            return sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(String sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(String sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        @Override
        public ResetNetworkInterfaceAttributeRequest build() {
            return new ResetNetworkInterfaceAttributeRequest(this);
        }
    }
}
