/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the private IPv4 address of a network interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class NetworkInterfacePrivateIpAddress implements
        ToCopyableBuilder<NetworkInterfacePrivateIpAddress.Builder, NetworkInterfacePrivateIpAddress> {
    private final NetworkInterfaceAssociation association;

    private final Boolean primary;

    private final String privateDnsName;

    private final String privateIpAddress;

    private NetworkInterfacePrivateIpAddress(BuilderImpl builder) {
        this.association = builder.association;
        this.primary = builder.primary;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
    }

    /**
     * <p>
     * The association information for an Elastic IP address (IPv4) associated with the network interface.
     * </p>
     * 
     * @return The association information for an Elastic IP address (IPv4) associated with the network interface.
     */
    public NetworkInterfaceAssociation association() {
        return association;
    }

    /**
     * <p>
     * Indicates whether this IPv4 address is the primary private IPv4 address of the network interface.
     * </p>
     * 
     * @return Indicates whether this IPv4 address is the primary private IPv4 address of the network interface.
     */
    public Boolean primary() {
        return primary;
    }

    /**
     * <p>
     * The private DNS name.
     * </p>
     * 
     * @return The private DNS name.
     */
    public String privateDnsName() {
        return privateDnsName;
    }

    /**
     * <p>
     * The private IPv4 address.
     * </p>
     * 
     * @return The private IPv4 address.
     */
    public String privateIpAddress() {
        return privateIpAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(association());
        hashCode = 31 * hashCode + Objects.hashCode(primary());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterfacePrivateIpAddress)) {
            return false;
        }
        NetworkInterfacePrivateIpAddress other = (NetworkInterfacePrivateIpAddress) obj;
        return Objects.equals(association(), other.association()) && Objects.equals(primary(), other.primary())
                && Objects.equals(privateDnsName(), other.privateDnsName())
                && Objects.equals(privateIpAddress(), other.privateIpAddress());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (association() != null) {
            sb.append("Association: ").append(association()).append(",");
        }
        if (primary() != null) {
            sb.append("Primary: ").append(primary()).append(",");
        }
        if (privateDnsName() != null) {
            sb.append("PrivateDnsName: ").append(privateDnsName()).append(",");
        }
        if (privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(privateIpAddress()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Association":
            return Optional.of(clazz.cast(association()));
        case "Primary":
            return Optional.of(clazz.cast(primary()));
        case "PrivateDnsName":
            return Optional.of(clazz.cast(privateDnsName()));
        case "PrivateIpAddress":
            return Optional.of(clazz.cast(privateIpAddress()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, NetworkInterfacePrivateIpAddress> {
        /**
         * <p>
         * The association information for an Elastic IP address (IPv4) associated with the network interface.
         * </p>
         * 
         * @param association
         *        The association information for an Elastic IP address (IPv4) associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder association(NetworkInterfaceAssociation association);

        /**
         * <p>
         * The association information for an Elastic IP address (IPv4) associated with the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkInterfaceAssociation.Builder} avoiding
         * the need to create one manually via {@link NetworkInterfaceAssociation#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkInterfaceAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link #association(NetworkInterfaceAssociation)}.
         * 
         * @param association
         *        a consumer that will call methods on {@link NetworkInterfaceAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #association(NetworkInterfaceAssociation)
         */
        default Builder association(Consumer<NetworkInterfaceAssociation.Builder> association) {
            return association(NetworkInterfaceAssociation.builder().apply(association).build());
        }

        /**
         * <p>
         * Indicates whether this IPv4 address is the primary private IPv4 address of the network interface.
         * </p>
         * 
         * @param primary
         *        Indicates whether this IPv4 address is the primary private IPv4 address of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primary(Boolean primary);

        /**
         * <p>
         * The private DNS name.
         * </p>
         * 
         * @param privateDnsName
         *        The private DNS name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsName(String privateDnsName);

        /**
         * <p>
         * The private IPv4 address.
         * </p>
         * 
         * @param privateIpAddress
         *        The private IPv4 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);
    }

    static final class BuilderImpl implements Builder {
        private NetworkInterfaceAssociation association;

        private Boolean primary;

        private String privateDnsName;

        private String privateIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterfacePrivateIpAddress model) {
            association(model.association);
            primary(model.primary);
            privateDnsName(model.privateDnsName);
            privateIpAddress(model.privateIpAddress);
        }

        public final NetworkInterfaceAssociation.Builder getAssociation() {
            return association != null ? association.toBuilder() : null;
        }

        @Override
        public final Builder association(NetworkInterfaceAssociation association) {
            this.association = association;
            return this;
        }

        public final void setAssociation(NetworkInterfaceAssociation.BuilderImpl association) {
            this.association = association != null ? association.build() : null;
        }

        public final Boolean getPrimary() {
            return primary;
        }

        @Override
        public final Builder primary(Boolean primary) {
            this.primary = primary;
            return this;
        }

        public final void setPrimary(Boolean primary) {
            this.primary = primary;
        }

        public final String getPrivateDnsName() {
            return privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public NetworkInterfacePrivateIpAddress build() {
            return new NetworkInterfacePrivateIpAddress(this);
        }
    }
}
