/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an attachment change.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class NetworkInterfaceAttachmentChanges implements
        ToCopyableBuilder<NetworkInterfaceAttachmentChanges.Builder, NetworkInterfaceAttachmentChanges> {
    private final String attachmentId;

    private final Boolean deleteOnTermination;

    private NetworkInterfaceAttachmentChanges(BuilderImpl builder) {
        this.attachmentId = builder.attachmentId;
        this.deleteOnTermination = builder.deleteOnTermination;
    }

    /**
     * <p>
     * The ID of the network interface attachment.
     * </p>
     * 
     * @return The ID of the network interface attachment.
     */
    public String attachmentId() {
        return attachmentId;
    }

    /**
     * <p>
     * Indicates whether the network interface is deleted when the instance is terminated.
     * </p>
     * 
     * @return Indicates whether the network interface is deleted when the instance is terminated.
     */
    public Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(deleteOnTermination());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterfaceAttachmentChanges)) {
            return false;
        }
        NetworkInterfaceAttachmentChanges other = (NetworkInterfaceAttachmentChanges) obj;
        return Objects.equals(attachmentId(), other.attachmentId())
                && Objects.equals(deleteOnTermination(), other.deleteOnTermination());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (attachmentId() != null) {
            sb.append("AttachmentId: ").append(attachmentId()).append(",");
        }
        if (deleteOnTermination() != null) {
            sb.append("DeleteOnTermination: ").append(deleteOnTermination()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachmentId":
            return Optional.of(clazz.cast(attachmentId()));
        case "DeleteOnTermination":
            return Optional.of(clazz.cast(deleteOnTermination()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, NetworkInterfaceAttachmentChanges> {
        /**
         * <p>
         * The ID of the network interface attachment.
         * </p>
         * 
         * @param attachmentId
         *        The ID of the network interface attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);

        /**
         * <p>
         * Indicates whether the network interface is deleted when the instance is terminated.
         * </p>
         * 
         * @param deleteOnTermination
         *        Indicates whether the network interface is deleted when the instance is terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);
    }

    static final class BuilderImpl implements Builder {
        private String attachmentId;

        private Boolean deleteOnTermination;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterfaceAttachmentChanges model) {
            attachmentId(model.attachmentId);
            deleteOnTermination(model.deleteOnTermination);
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public NetworkInterfaceAttachmentChanges build() {
            return new NetworkInterfaceAttachmentChanges(this);
        }
    }
}
