/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifyVpcPeeringConnectionOptionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ModifyVpcPeeringConnectionOptionsResponse.Builder, ModifyVpcPeeringConnectionOptionsResponse> {
    private final PeeringConnectionOptions accepterPeeringConnectionOptions;

    private final PeeringConnectionOptions requesterPeeringConnectionOptions;

    private ModifyVpcPeeringConnectionOptionsResponse(BuilderImpl builder) {
        this.accepterPeeringConnectionOptions = builder.accepterPeeringConnectionOptions;
        this.requesterPeeringConnectionOptions = builder.requesterPeeringConnectionOptions;
    }

    /**
     * <p>
     * Information about the VPC peering connection options for the accepter VPC.
     * </p>
     * 
     * @return Information about the VPC peering connection options for the accepter VPC.
     */
    public PeeringConnectionOptions accepterPeeringConnectionOptions() {
        return accepterPeeringConnectionOptions;
    }

    /**
     * <p>
     * Information about the VPC peering connection options for the requester VPC.
     * </p>
     * 
     * @return Information about the VPC peering connection options for the requester VPC.
     */
    public PeeringConnectionOptions requesterPeeringConnectionOptions() {
        return requesterPeeringConnectionOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accepterPeeringConnectionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(requesterPeeringConnectionOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcPeeringConnectionOptionsResponse)) {
            return false;
        }
        ModifyVpcPeeringConnectionOptionsResponse other = (ModifyVpcPeeringConnectionOptionsResponse) obj;
        return Objects.equals(accepterPeeringConnectionOptions(), other.accepterPeeringConnectionOptions())
                && Objects.equals(requesterPeeringConnectionOptions(), other.requesterPeeringConnectionOptions());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (accepterPeeringConnectionOptions() != null) {
            sb.append("AccepterPeeringConnectionOptions: ").append(accepterPeeringConnectionOptions()).append(",");
        }
        if (requesterPeeringConnectionOptions() != null) {
            sb.append("RequesterPeeringConnectionOptions: ").append(requesterPeeringConnectionOptions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccepterPeeringConnectionOptions":
            return Optional.of(clazz.cast(accepterPeeringConnectionOptions()));
        case "RequesterPeeringConnectionOptions":
            return Optional.of(clazz.cast(requesterPeeringConnectionOptions()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ModifyVpcPeeringConnectionOptionsResponse> {
        /**
         * <p>
         * Information about the VPC peering connection options for the accepter VPC.
         * </p>
         * 
         * @param accepterPeeringConnectionOptions
         *        Information about the VPC peering connection options for the accepter VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accepterPeeringConnectionOptions(PeeringConnectionOptions accepterPeeringConnectionOptions);

        /**
         * <p>
         * Information about the VPC peering connection options for the accepter VPC.
         * </p>
         * This is a convenience that creates an instance of the {@link PeeringConnectionOptions.Builder} avoiding the
         * need to create one manually via {@link PeeringConnectionOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link PeeringConnectionOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #accepterPeeringConnectionOptions(PeeringConnectionOptions)}.
         * 
         * @param accepterPeeringConnectionOptions
         *        a consumer that will call methods on {@link PeeringConnectionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accepterPeeringConnectionOptions(PeeringConnectionOptions)
         */
        default Builder accepterPeeringConnectionOptions(
                Consumer<PeeringConnectionOptions.Builder> accepterPeeringConnectionOptions) {
            return accepterPeeringConnectionOptions(PeeringConnectionOptions.builder().apply(accepterPeeringConnectionOptions)
                    .build());
        }

        /**
         * <p>
         * Information about the VPC peering connection options for the requester VPC.
         * </p>
         * 
         * @param requesterPeeringConnectionOptions
         *        Information about the VPC peering connection options for the requester VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterPeeringConnectionOptions(PeeringConnectionOptions requesterPeeringConnectionOptions);

        /**
         * <p>
         * Information about the VPC peering connection options for the requester VPC.
         * </p>
         * This is a convenience that creates an instance of the {@link PeeringConnectionOptions.Builder} avoiding the
         * need to create one manually via {@link PeeringConnectionOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link PeeringConnectionOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #requesterPeeringConnectionOptions(PeeringConnectionOptions)}.
         * 
         * @param requesterPeeringConnectionOptions
         *        a consumer that will call methods on {@link PeeringConnectionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requesterPeeringConnectionOptions(PeeringConnectionOptions)
         */
        default Builder requesterPeeringConnectionOptions(
                Consumer<PeeringConnectionOptions.Builder> requesterPeeringConnectionOptions) {
            return requesterPeeringConnectionOptions(PeeringConnectionOptions.builder().apply(requesterPeeringConnectionOptions)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PeeringConnectionOptions accepterPeeringConnectionOptions;

        private PeeringConnectionOptions requesterPeeringConnectionOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcPeeringConnectionOptionsResponse model) {
            accepterPeeringConnectionOptions(model.accepterPeeringConnectionOptions);
            requesterPeeringConnectionOptions(model.requesterPeeringConnectionOptions);
        }

        public final PeeringConnectionOptions.Builder getAccepterPeeringConnectionOptions() {
            return accepterPeeringConnectionOptions != null ? accepterPeeringConnectionOptions.toBuilder() : null;
        }

        @Override
        public final Builder accepterPeeringConnectionOptions(PeeringConnectionOptions accepterPeeringConnectionOptions) {
            this.accepterPeeringConnectionOptions = accepterPeeringConnectionOptions;
            return this;
        }

        public final void setAccepterPeeringConnectionOptions(
                PeeringConnectionOptions.BuilderImpl accepterPeeringConnectionOptions) {
            this.accepterPeeringConnectionOptions = accepterPeeringConnectionOptions != null ? accepterPeeringConnectionOptions
                    .build() : null;
        }

        public final PeeringConnectionOptions.Builder getRequesterPeeringConnectionOptions() {
            return requesterPeeringConnectionOptions != null ? requesterPeeringConnectionOptions.toBuilder() : null;
        }

        @Override
        public final Builder requesterPeeringConnectionOptions(PeeringConnectionOptions requesterPeeringConnectionOptions) {
            this.requesterPeeringConnectionOptions = requesterPeeringConnectionOptions;
            return this;
        }

        public final void setRequesterPeeringConnectionOptions(
                PeeringConnectionOptions.BuilderImpl requesterPeeringConnectionOptions) {
            this.requesterPeeringConnectionOptions = requesterPeeringConnectionOptions != null ? requesterPeeringConnectionOptions
                    .build() : null;
        }

        @Override
        public ModifyVpcPeeringConnectionOptionsResponse build() {
            return new ModifyVpcPeeringConnectionOptionsResponse(this);
        }
    }
}
