/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ModifyInstancePlacement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifyInstancePlacementRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ModifyInstancePlacementRequest.Builder, ModifyInstancePlacementRequest> {
    private final String affinity;

    private final String hostId;

    private final String instanceId;

    private final String tenancy;

    private ModifyInstancePlacementRequest(BuilderImpl builder) {
        this.affinity = builder.affinity;
        this.hostId = builder.hostId;
        this.instanceId = builder.instanceId;
        this.tenancy = builder.tenancy;
    }

    /**
     * <p>
     * The new affinity setting for the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #affinity} will
     * return {@link Affinity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #affinityString}.
     * </p>
     * 
     * @return The new affinity setting for the instance.
     * @see Affinity
     */
    public Affinity affinity() {
        return Affinity.fromValue(affinity);
    }

    /**
     * <p>
     * The new affinity setting for the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #affinity} will
     * return {@link Affinity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #affinityString}.
     * </p>
     * 
     * @return The new affinity setting for the instance.
     * @see Affinity
     */
    public String affinityString() {
        return affinity;
    }

    /**
     * <p>
     * The ID of the Dedicated Host that the instance will have affinity with.
     * </p>
     * 
     * @return The ID of the Dedicated Host that the instance will have affinity with.
     */
    public String hostId() {
        return hostId;
    }

    /**
     * <p>
     * The ID of the instance that you are modifying.
     * </p>
     * 
     * @return The ID of the instance that you are modifying.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The tenancy of the instance that you are modifying.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link HostTenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tenancyString}.
     * </p>
     * 
     * @return The tenancy of the instance that you are modifying.
     * @see HostTenancy
     */
    public HostTenancy tenancy() {
        return HostTenancy.fromValue(tenancy);
    }

    /**
     * <p>
     * The tenancy of the instance that you are modifying.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link HostTenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tenancyString}.
     * </p>
     * 
     * @return The tenancy of the instance that you are modifying.
     * @see HostTenancy
     */
    public String tenancyString() {
        return tenancy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(affinityString());
        hashCode = 31 * hashCode + Objects.hashCode(hostId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(tenancyString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstancePlacementRequest)) {
            return false;
        }
        ModifyInstancePlacementRequest other = (ModifyInstancePlacementRequest) obj;
        return Objects.equals(affinityString(), other.affinityString()) && Objects.equals(hostId(), other.hostId())
                && Objects.equals(instanceId(), other.instanceId()) && Objects.equals(tenancyString(), other.tenancyString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (affinityString() != null) {
            sb.append("Affinity: ").append(affinityString()).append(",");
        }
        if (hostId() != null) {
            sb.append("HostId: ").append(hostId()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (tenancyString() != null) {
            sb.append("Tenancy: ").append(tenancyString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Affinity":
            return Optional.of(clazz.cast(affinityString()));
        case "HostId":
            return Optional.of(clazz.cast(hostId()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "Tenancy":
            return Optional.of(clazz.cast(tenancyString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ModifyInstancePlacementRequest> {
        /**
         * <p>
         * The new affinity setting for the instance.
         * </p>
         * 
         * @param affinity
         *        The new affinity setting for the instance.
         * @see Affinity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Affinity
         */
        Builder affinity(String affinity);

        /**
         * <p>
         * The new affinity setting for the instance.
         * </p>
         * 
         * @param affinity
         *        The new affinity setting for the instance.
         * @see Affinity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Affinity
         */
        Builder affinity(Affinity affinity);

        /**
         * <p>
         * The ID of the Dedicated Host that the instance will have affinity with.
         * </p>
         * 
         * @param hostId
         *        The ID of the Dedicated Host that the instance will have affinity with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostId(String hostId);

        /**
         * <p>
         * The ID of the instance that you are modifying.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance that you are modifying.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The tenancy of the instance that you are modifying.
         * </p>
         * 
         * @param tenancy
         *        The tenancy of the instance that you are modifying.
         * @see HostTenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostTenancy
         */
        Builder tenancy(String tenancy);

        /**
         * <p>
         * The tenancy of the instance that you are modifying.
         * </p>
         * 
         * @param tenancy
         *        The tenancy of the instance that you are modifying.
         * @see HostTenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostTenancy
         */
        Builder tenancy(HostTenancy tenancy);
    }

    static final class BuilderImpl implements Builder {
        private String affinity;

        private String hostId;

        private String instanceId;

        private String tenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstancePlacementRequest model) {
            affinity(model.affinity);
            hostId(model.hostId);
            instanceId(model.instanceId);
            tenancy(model.tenancy);
        }

        public final String getAffinity() {
            return affinity;
        }

        @Override
        public final Builder affinity(String affinity) {
            this.affinity = affinity;
            return this;
        }

        @Override
        public final Builder affinity(Affinity affinity) {
            this.affinity(affinity.toString());
            return this;
        }

        public final void setAffinity(String affinity) {
            this.affinity = affinity;
        }

        public final String getHostId() {
            return hostId;
        }

        @Override
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getTenancy() {
            return tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(HostTenancy tenancy) {
            this.tenancy(tenancy.toString());
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public ModifyInstancePlacementRequest build() {
            return new ModifyInstancePlacementRequest(this);
        }
    }
}
