/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a launch permission.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LaunchPermission implements ToCopyableBuilder<LaunchPermission.Builder, LaunchPermission> {
    private final String group;

    private final String userId;

    private LaunchPermission(BuilderImpl builder) {
        this.group = builder.group;
        this.userId = builder.userId;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #group} will return
     * {@link PermissionGroup#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupString}.
     * </p>
     * 
     * @return The name of the group.
     * @see PermissionGroup
     */
    public PermissionGroup group() {
        return PermissionGroup.fromValue(group);
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #group} will return
     * {@link PermissionGroup#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupString}.
     * </p>
     * 
     * @return The name of the group.
     * @see PermissionGroup
     */
    public String groupString() {
        return group;
    }

    /**
     * <p>
     * The AWS account ID.
     * </p>
     * 
     * @return The AWS account ID.
     */
    public String userId() {
        return userId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupString());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchPermission)) {
            return false;
        }
        LaunchPermission other = (LaunchPermission) obj;
        return Objects.equals(groupString(), other.groupString()) && Objects.equals(userId(), other.userId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (groupString() != null) {
            sb.append("Group: ").append(groupString()).append(",");
        }
        if (userId() != null) {
            sb.append("UserId: ").append(userId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Group":
            return Optional.of(clazz.cast(groupString()));
        case "UserId":
            return Optional.of(clazz.cast(userId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, LaunchPermission> {
        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param group
         *        The name of the group.
         * @see PermissionGroup
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionGroup
         */
        Builder group(String group);

        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param group
         *        The name of the group.
         * @see PermissionGroup
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionGroup
         */
        Builder group(PermissionGroup group);

        /**
         * <p>
         * The AWS account ID.
         * </p>
         * 
         * @param userId
         *        The AWS account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);
    }

    static final class BuilderImpl implements Builder {
        private String group;

        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchPermission model) {
            group(model.group);
            userId(model.userId);
        }

        public final String getGroup() {
            return group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        @Override
        public final Builder group(PermissionGroup group) {
            this.group(group.toString());
            return this;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public LaunchPermission build() {
            return new LaunchPermission(this);
        }
    }
}
