/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetConsoleScreenshotRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetConsoleScreenshotRequest.Builder, GetConsoleScreenshotRequest> {
    private final String instanceId;

    private final Boolean wakeUp;

    private GetConsoleScreenshotRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.wakeUp = builder.wakeUp;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * When set to <code>true</code>, acts as keystroke input and wakes up an instance that's in standby or "sleep"
     * mode.
     * </p>
     * 
     * @return When set to <code>true</code>, acts as keystroke input and wakes up an instance that's in standby or
     *         "sleep" mode.
     */
    public Boolean wakeUp() {
        return wakeUp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(wakeUp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConsoleScreenshotRequest)) {
            return false;
        }
        GetConsoleScreenshotRequest other = (GetConsoleScreenshotRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(wakeUp(), other.wakeUp());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (wakeUp() != null) {
            sb.append("WakeUp: ").append(wakeUp()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "WakeUp":
            return Optional.of(clazz.cast(wakeUp()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetConsoleScreenshotRequest> {
        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * When set to <code>true</code>, acts as keystroke input and wakes up an instance that's in standby or "sleep"
         * mode.
         * </p>
         * 
         * @param wakeUp
         *        When set to <code>true</code>, acts as keystroke input and wakes up an instance that's in standby or
         *        "sleep" mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wakeUp(Boolean wakeUp);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private Boolean wakeUp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConsoleScreenshotRequest model) {
            instanceId(model.instanceId);
            wakeUp(model.wakeUp);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Boolean getWakeUp() {
            return wakeUp;
        }

        @Override
        public final Builder wakeUp(Boolean wakeUp) {
            this.wakeUp = wakeUp;
            return this;
        }

        public final void setWakeUp(Boolean wakeUp) {
            this.wakeUp = wakeUp;
        }

        @Override
        public GetConsoleScreenshotRequest build() {
            return new GetConsoleScreenshotRequest(this);
        }
    }
}
