/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSecurityGroupReferencesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeSecurityGroupReferencesResponse.Builder, DescribeSecurityGroupReferencesResponse> {
    private final List<SecurityGroupReference> securityGroupReferenceSet;

    private DescribeSecurityGroupReferencesResponse(BuilderImpl builder) {
        this.securityGroupReferenceSet = builder.securityGroupReferenceSet;
    }

    /**
     * <p>
     * Information about the VPCs with the referencing security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the VPCs with the referencing security groups.
     */
    public List<SecurityGroupReference> securityGroupReferenceSet() {
        return securityGroupReferenceSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupReferenceSet());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecurityGroupReferencesResponse)) {
            return false;
        }
        DescribeSecurityGroupReferencesResponse other = (DescribeSecurityGroupReferencesResponse) obj;
        return Objects.equals(securityGroupReferenceSet(), other.securityGroupReferenceSet());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (securityGroupReferenceSet() != null) {
            sb.append("SecurityGroupReferenceSet: ").append(securityGroupReferenceSet()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityGroupReferenceSet":
            return Optional.of(clazz.cast(securityGroupReferenceSet()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeSecurityGroupReferencesResponse> {
        /**
         * <p>
         * Information about the VPCs with the referencing security groups.
         * </p>
         * 
         * @param securityGroupReferenceSet
         *        Information about the VPCs with the referencing security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupReferenceSet(Collection<SecurityGroupReference> securityGroupReferenceSet);

        /**
         * <p>
         * Information about the VPCs with the referencing security groups.
         * </p>
         * 
         * @param securityGroupReferenceSet
         *        Information about the VPCs with the referencing security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupReferenceSet(SecurityGroupReference... securityGroupReferenceSet);
    }

    static final class BuilderImpl implements Builder {
        private List<SecurityGroupReference> securityGroupReferenceSet;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecurityGroupReferencesResponse model) {
            securityGroupReferenceSet(model.securityGroupReferenceSet);
        }

        public final Collection<SecurityGroupReference.Builder> getSecurityGroupReferenceSet() {
            return securityGroupReferenceSet != null ? securityGroupReferenceSet.stream().map(SecurityGroupReference::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder securityGroupReferenceSet(Collection<SecurityGroupReference> securityGroupReferenceSet) {
            this.securityGroupReferenceSet = SecurityGroupReferencesCopier.copy(securityGroupReferenceSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupReferenceSet(SecurityGroupReference... securityGroupReferenceSet) {
            securityGroupReferenceSet(Arrays.asList(securityGroupReferenceSet));
            return this;
        }

        public final void setSecurityGroupReferenceSet(Collection<SecurityGroupReference.BuilderImpl> securityGroupReferenceSet) {
            this.securityGroupReferenceSet = SecurityGroupReferencesCopier.copyFromBuilder(securityGroupReferenceSet);
        }

        @Override
        public DescribeSecurityGroupReferencesResponse build() {
            return new DescribeSecurityGroupReferencesResponse(this);
        }
    }
}
