/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeScheduledInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeScheduledInstancesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeScheduledInstancesResponse.Builder, DescribeScheduledInstancesResponse> {
    private final String nextToken;

    private final List<ScheduledInstance> scheduledInstanceSet;

    private DescribeScheduledInstancesResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.scheduledInstanceSet = builder.scheduledInstanceSet;
    }

    /**
     * <p>
     * The token required to retrieve the next set of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token required to retrieve the next set of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Information about the Scheduled Instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the Scheduled Instances.
     */
    public List<ScheduledInstance> scheduledInstanceSet() {
        return scheduledInstanceSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledInstanceSet());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledInstancesResponse)) {
            return false;
        }
        DescribeScheduledInstancesResponse other = (DescribeScheduledInstancesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(scheduledInstanceSet(), other.scheduledInstanceSet());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (scheduledInstanceSet() != null) {
            sb.append("ScheduledInstanceSet: ").append(scheduledInstanceSet()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "ScheduledInstanceSet":
            return Optional.of(clazz.cast(scheduledInstanceSet()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeScheduledInstancesResponse> {
        /**
         * <p>
         * The token required to retrieve the next set of results. This value is <code>null</code> when there are no
         * more results to return.
         * </p>
         * 
         * @param nextToken
         *        The token required to retrieve the next set of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the Scheduled Instances.
         * </p>
         * 
         * @param scheduledInstanceSet
         *        Information about the Scheduled Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledInstanceSet(Collection<ScheduledInstance> scheduledInstanceSet);

        /**
         * <p>
         * Information about the Scheduled Instances.
         * </p>
         * 
         * @param scheduledInstanceSet
         *        Information about the Scheduled Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledInstanceSet(ScheduledInstance... scheduledInstanceSet);
    }

    static final class BuilderImpl implements Builder {
        private String nextToken;

        private List<ScheduledInstance> scheduledInstanceSet;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledInstancesResponse model) {
            nextToken(model.nextToken);
            scheduledInstanceSet(model.scheduledInstanceSet);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ScheduledInstance.Builder> getScheduledInstanceSet() {
            return scheduledInstanceSet != null ? scheduledInstanceSet.stream().map(ScheduledInstance::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scheduledInstanceSet(Collection<ScheduledInstance> scheduledInstanceSet) {
            this.scheduledInstanceSet = ScheduledInstanceSetCopier.copy(scheduledInstanceSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledInstanceSet(ScheduledInstance... scheduledInstanceSet) {
            scheduledInstanceSet(Arrays.asList(scheduledInstanceSet));
            return this;
        }

        public final void setScheduledInstanceSet(Collection<ScheduledInstance.BuilderImpl> scheduledInstanceSet) {
            this.scheduledInstanceSet = ScheduledInstanceSetCopier.copyFromBuilder(scheduledInstanceSet);
        }

        @Override
        public DescribeScheduledInstancesResponse build() {
            return new DescribeScheduledInstancesResponse(this);
        }
    }
}
