/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribePrefixLists.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribePrefixListsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribePrefixListsResponse.Builder, DescribePrefixListsResponse> {
    private final String nextToken;

    private final List<PrefixList> prefixLists;

    private DescribePrefixListsResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.prefixLists = builder.prefixLists;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * All available prefix lists.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return All available prefix lists.
     */
    public List<PrefixList> prefixLists() {
        return prefixLists;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(prefixLists());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePrefixListsResponse)) {
            return false;
        }
        DescribePrefixListsResponse other = (DescribePrefixListsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(prefixLists(), other.prefixLists());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (prefixLists() != null) {
            sb.append("PrefixLists: ").append(prefixLists()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "PrefixLists":
            return Optional.of(clazz.cast(prefixLists()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribePrefixListsResponse> {
        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * All available prefix lists.
         * </p>
         * 
         * @param prefixLists
         *        All available prefix lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixLists(Collection<PrefixList> prefixLists);

        /**
         * <p>
         * All available prefix lists.
         * </p>
         * 
         * @param prefixLists
         *        All available prefix lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixLists(PrefixList... prefixLists);
    }

    static final class BuilderImpl implements Builder {
        private String nextToken;

        private List<PrefixList> prefixLists;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePrefixListsResponse model) {
            nextToken(model.nextToken);
            prefixLists(model.prefixLists);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<PrefixList.Builder> getPrefixLists() {
            return prefixLists != null ? prefixLists.stream().map(PrefixList::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder prefixLists(Collection<PrefixList> prefixLists) {
            this.prefixLists = PrefixListSetCopier.copy(prefixLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixLists(PrefixList... prefixLists) {
            prefixLists(Arrays.asList(prefixLists));
            return this;
        }

        public final void setPrefixLists(Collection<PrefixList.BuilderImpl> prefixLists) {
            this.prefixLists = PrefixListSetCopier.copyFromBuilder(prefixLists);
        }

        @Override
        public DescribePrefixListsResponse build() {
            return new DescribePrefixListsResponse(this);
        }
    }
}
