/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeNetworkAcls.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeNetworkAclsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeNetworkAclsRequest.Builder, DescribeNetworkAclsRequest> {
    private final List<Filter> filters;

    private final List<String> networkAclIds;

    private DescribeNetworkAclsRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.networkAclIds = builder.networkAclIds;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>association.association-id</code> - The ID of an association ID for the ACL.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>association.network-acl-id</code> - The ID of the network ACL involved in the association.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>association.subnet-id</code> - The ID of the subnet involved in the association.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>default</code> - Indicates whether the ACL is the default network ACL for the VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>entry.cidr</code> - The IPv4 CIDR range specified in the entry.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>entry.egress</code> - Indicates whether the entry applies to egress traffic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>entry.icmp.code</code> - The ICMP code specified in the entry, if any.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>entry.icmp.type</code> - The ICMP type specified in the entry, if any.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>entry.ipv6-cidr</code> - The IPv6 CIDR range specified in the entry.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>entry.port-range.from</code> - The start of the port range specified in the entry.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>entry.port-range.to</code> - The end of the port range specified in the entry.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>entry.protocol</code> - The protocol specified in the entry (<code>tcp</code> | <code>udp</code> |
     * <code>icmp</code> or a protocol number).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>entry.rule-action</code> - Allows or denies the matching traffic (<code>allow</code> | <code>deny</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>entry.rule-number</code> - The number of an entry (in other words, rule) in the ACL's set of entries.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-acl-id</code> - The ID of the network ACL.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource. Specify
     * the key of the tag in the filter name and the value of the tag in the filter value. For example, for the tag
     * Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value is),
     * and the tag value X (regardless of what the tag's key is). If you want to list only resources where Purpose is X,
     * see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     * <code>tag-key</code> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-id</code> - The ID of the VPC for the network ACL.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>association.association-id</code> - The ID of an association ID for the ACL.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>association.network-acl-id</code> - The ID of the network ACL involved in the association.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>association.subnet-id</code> - The ID of the subnet involved in the association.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>default</code> - Indicates whether the ACL is the default network ACL for the VPC.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>entry.cidr</code> - The IPv4 CIDR range specified in the entry.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>entry.egress</code> - Indicates whether the entry applies to egress traffic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>entry.icmp.code</code> - The ICMP code specified in the entry, if any.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>entry.icmp.type</code> - The ICMP type specified in the entry, if any.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>entry.ipv6-cidr</code> - The IPv6 CIDR range specified in the entry.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>entry.port-range.from</code> - The start of the port range specified in the entry.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>entry.port-range.to</code> - The end of the port range specified in the entry.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>entry.protocol</code> - The protocol specified in the entry (<code>tcp</code> | <code>udp</code> |
     *         <code>icmp</code> or a protocol number).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>entry.rule-action</code> - Allows or denies the matching traffic (<code>allow</code> |
     *         <code>deny</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>entry.rule-number</code> - The number of an entry (in other words, rule) in the ACL's set of
     *         entries.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-acl-id</code> - The ID of the network ACL.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
     *         Specify the key of the tag in the filter name and the value of the tag in the filter value. For example,
     *         for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the
     *         filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     *         "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's
     *         value is), and the tag value X (regardless of what the tag's key is). If you want to list only resources
     *         where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-key</code> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpc-id</code> - The ID of the VPC for the network ACL.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * One or more network ACL IDs.
     * </p>
     * <p>
     * Default: Describes all your network ACLs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more network ACL IDs.</p>
     *         <p>
     *         Default: Describes all your network ACLs.
     */
    public List<String> networkAclIds() {
        return networkAclIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(networkAclIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkAclsRequest)) {
            return false;
        }
        DescribeNetworkAclsRequest other = (DescribeNetworkAclsRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(networkAclIds(), other.networkAclIds());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (networkAclIds() != null) {
            sb.append("NetworkAclIds: ").append(networkAclIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "NetworkAclIds":
            return Optional.of(clazz.cast(networkAclIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeNetworkAclsRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>association.association-id</code> - The ID of an association ID for the ACL.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.network-acl-id</code> - The ID of the network ACL involved in the association.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.subnet-id</code> - The ID of the subnet involved in the association.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>default</code> - Indicates whether the ACL is the default network ACL for the VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>entry.cidr</code> - The IPv4 CIDR range specified in the entry.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>entry.egress</code> - Indicates whether the entry applies to egress traffic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>entry.icmp.code</code> - The ICMP code specified in the entry, if any.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>entry.icmp.type</code> - The ICMP type specified in the entry, if any.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>entry.ipv6-cidr</code> - The IPv6 CIDR range specified in the entry.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>entry.port-range.from</code> - The start of the port range specified in the entry.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>entry.port-range.to</code> - The end of the port range specified in the entry.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>entry.protocol</code> - The protocol specified in the entry (<code>tcp</code> | <code>udp</code> |
         * <code>icmp</code> or a protocol number).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>entry.rule-action</code> - Allows or denies the matching traffic (<code>allow</code> |
         * <code>deny</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>entry.rule-number</code> - The number of an entry (in other words, rule) in the ACL's set of entries.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-acl-id</code> - The ID of the network ACL.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC for the network ACL.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>association.association-id</code> - The ID of an association ID for the ACL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.network-acl-id</code> - The ID of the network ACL involved in the association.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.subnet-id</code> - The ID of the subnet involved in the association.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>default</code> - Indicates whether the ACL is the default network ACL for the VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>entry.cidr</code> - The IPv4 CIDR range specified in the entry.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>entry.egress</code> - Indicates whether the entry applies to egress traffic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>entry.icmp.code</code> - The ICMP code specified in the entry, if any.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>entry.icmp.type</code> - The ICMP type specified in the entry, if any.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>entry.ipv6-cidr</code> - The IPv6 CIDR range specified in the entry.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>entry.port-range.from</code> - The start of the port range specified in the entry.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>entry.port-range.to</code> - The end of the port range specified in the entry.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>entry.protocol</code> - The protocol specified in the entry (<code>tcp</code> | <code>udp</code>
         *        | <code>icmp</code> or a protocol number).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>entry.rule-action</code> - Allows or denies the matching traffic (<code>allow</code> |
         *        <code>deny</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>entry.rule-number</code> - The number of an entry (in other words, rule) in the ACL's set of
         *        entries.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-acl-id</code> - The ID of the network ACL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC for the network ACL.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>association.association-id</code> - The ID of an association ID for the ACL.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.network-acl-id</code> - The ID of the network ACL involved in the association.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.subnet-id</code> - The ID of the subnet involved in the association.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>default</code> - Indicates whether the ACL is the default network ACL for the VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>entry.cidr</code> - The IPv4 CIDR range specified in the entry.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>entry.egress</code> - Indicates whether the entry applies to egress traffic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>entry.icmp.code</code> - The ICMP code specified in the entry, if any.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>entry.icmp.type</code> - The ICMP type specified in the entry, if any.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>entry.ipv6-cidr</code> - The IPv6 CIDR range specified in the entry.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>entry.port-range.from</code> - The start of the port range specified in the entry.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>entry.port-range.to</code> - The end of the port range specified in the entry.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>entry.protocol</code> - The protocol specified in the entry (<code>tcp</code> | <code>udp</code> |
         * <code>icmp</code> or a protocol number).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>entry.rule-action</code> - Allows or denies the matching traffic (<code>allow</code> |
         * <code>deny</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>entry.rule-number</code> - The number of an entry (in other words, rule) in the ACL's set of entries.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-acl-id</code> - The ID of the network ACL.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC for the network ACL.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>association.association-id</code> - The ID of an association ID for the ACL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.network-acl-id</code> - The ID of the network ACL involved in the association.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.subnet-id</code> - The ID of the subnet involved in the association.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>default</code> - Indicates whether the ACL is the default network ACL for the VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>entry.cidr</code> - The IPv4 CIDR range specified in the entry.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>entry.egress</code> - Indicates whether the entry applies to egress traffic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>entry.icmp.code</code> - The ICMP code specified in the entry, if any.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>entry.icmp.type</code> - The ICMP type specified in the entry, if any.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>entry.ipv6-cidr</code> - The IPv6 CIDR range specified in the entry.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>entry.port-range.from</code> - The start of the port range specified in the entry.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>entry.port-range.to</code> - The end of the port range specified in the entry.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>entry.protocol</code> - The protocol specified in the entry (<code>tcp</code> | <code>udp</code>
         *        | <code>icmp</code> or a protocol number).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>entry.rule-action</code> - Allows or denies the matching traffic (<code>allow</code> |
         *        <code>deny</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>entry.rule-number</code> - The number of an entry (in other words, rule) in the ACL's set of
         *        entries.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-acl-id</code> - The ID of the network ACL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC for the network ACL.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more network ACL IDs.
         * </p>
         * <p>
         * Default: Describes all your network ACLs.
         * </p>
         * 
         * @param networkAclIds
         *        One or more network ACL IDs.</p>
         *        <p>
         *        Default: Describes all your network ACLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAclIds(Collection<String> networkAclIds);

        /**
         * <p>
         * One or more network ACL IDs.
         * </p>
         * <p>
         * Default: Describes all your network ACLs.
         * </p>
         * 
         * @param networkAclIds
         *        One or more network ACL IDs.</p>
         *        <p>
         *        Default: Describes all your network ACLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAclIds(String... networkAclIds);
    }

    static final class BuilderImpl implements Builder {
        private List<Filter> filters;

        private List<String> networkAclIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkAclsRequest model) {
            filters(model.filters);
            networkAclIds(model.networkAclIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getNetworkAclIds() {
            return networkAclIds;
        }

        @Override
        public final Builder networkAclIds(Collection<String> networkAclIds) {
            this.networkAclIds = ValueStringListCopier.copy(networkAclIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkAclIds(String... networkAclIds) {
            networkAclIds(Arrays.asList(networkAclIds));
            return this;
        }

        public final void setNetworkAclIds(Collection<String> networkAclIds) {
            this.networkAclIds = ValueStringListCopier.copy(networkAclIds);
        }

        @Override
        public DescribeNetworkAclsRequest build() {
            return new DescribeNetworkAclsRequest(this);
        }
    }
}
