/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A simple result wrapper around the InstanceAttribute object that was sent over the wire.
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeInstanceAttributeResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeInstanceAttributeResponse.Builder, DescribeInstanceAttributeResponse> {
    private final InstanceAttribute instanceAttribute;

    private DescribeInstanceAttributeResponse(BuilderImpl builder) {
        this.instanceAttribute = builder.instanceAttribute;
    }

    /**
     * <p>
     * Describes an instance attribute.
     * </p>
     * 
     * @return Describes an instance attribute.
     */
    public InstanceAttribute instanceAttribute() {
        return instanceAttribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceAttribute());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceAttributeResponse)) {
            return false;
        }
        DescribeInstanceAttributeResponse other = (DescribeInstanceAttributeResponse) obj;
        return Objects.equals(instanceAttribute(), other.instanceAttribute());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (instanceAttribute() != null) {
            sb.append("InstanceAttribute: ").append(instanceAttribute()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceAttribute":
            return Optional.of(clazz.cast(instanceAttribute()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeInstanceAttributeResponse> {
        /**
         * <p>
         * Describes an instance attribute.
         * </p>
         * 
         * @param instanceAttribute
         *        Describes an instance attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceAttribute(InstanceAttribute instanceAttribute);

        /**
         * <p>
         * Describes an instance attribute.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceAttribute.Builder} avoiding the need to
         * create one manually via {@link InstanceAttribute#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceAttribute(InstanceAttribute)}.
         * 
         * @param instanceAttribute
         *        a consumer that will call methods on {@link InstanceAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceAttribute(InstanceAttribute)
         */
        default Builder instanceAttribute(Consumer<InstanceAttribute.Builder> instanceAttribute) {
            return instanceAttribute(InstanceAttribute.builder().apply(instanceAttribute).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InstanceAttribute instanceAttribute;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceAttributeResponse model) {
            instanceAttribute(model.instanceAttribute);
        }

        public final InstanceAttribute.Builder getInstanceAttribute() {
            return instanceAttribute != null ? instanceAttribute.toBuilder() : null;
        }

        @Override
        public final Builder instanceAttribute(InstanceAttribute instanceAttribute) {
            this.instanceAttribute = instanceAttribute;
            return this;
        }

        public final void setInstanceAttribute(InstanceAttribute.BuilderImpl instanceAttribute) {
            this.instanceAttribute = instanceAttribute != null ? instanceAttribute.build() : null;
        }

        @Override
        public DescribeInstanceAttributeResponse build() {
            return new DescribeInstanceAttributeResponse(this);
        }
    }
}
