/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeImportSnapshotTasks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeImportSnapshotTasksRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeImportSnapshotTasksRequest.Builder, DescribeImportSnapshotTasksRequest> {
    private final List<Filter> filters;

    private final List<String> importTaskIds;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeImportSnapshotTasksRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.importTaskIds = builder.importTaskIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * A list of import snapshot task IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of import snapshot task IDs.
     */
    public List<String> importTaskIds() {
        return importTaskIds;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. To retrieve the remaining results, make another call
     * with the returned <code>NextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. To retrieve the remaining results, make another
     *         call with the returned <code>NextToken</code> value.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token that indicates the next page of results.
     * </p>
     * 
     * @return A token that indicates the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(importTaskIds());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImportSnapshotTasksRequest)) {
            return false;
        }
        DescribeImportSnapshotTasksRequest other = (DescribeImportSnapshotTasksRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(importTaskIds(), other.importTaskIds())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (importTaskIds() != null) {
            sb.append("ImportTaskIds: ").append(importTaskIds()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "ImportTaskIds":
            return Optional.of(clazz.cast(importTaskIds()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeImportSnapshotTasksRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * 
         * @param filters
         *        One or more filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * 
         * @param filters
         *        One or more filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * A list of import snapshot task IDs.
         * </p>
         * 
         * @param importTaskIds
         *        A list of import snapshot task IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importTaskIds(Collection<String> importTaskIds);

        /**
         * <p>
         * A list of import snapshot task IDs.
         * </p>
         * 
         * @param importTaskIds
         *        A list of import snapshot task IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importTaskIds(String... importTaskIds);

        /**
         * <p>
         * The maximum number of results to return in a single call. To retrieve the remaining results, make another
         * call with the returned <code>NextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. To retrieve the remaining results, make
         *        another call with the returned <code>NextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token that indicates the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<Filter> filters;

        private List<String> importTaskIds;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImportSnapshotTasksRequest model) {
            filters(model.filters);
            importTaskIds(model.importTaskIds);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getImportTaskIds() {
            return importTaskIds;
        }

        @Override
        public final Builder importTaskIds(Collection<String> importTaskIds) {
            this.importTaskIds = ImportTaskIdListCopier.copy(importTaskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importTaskIds(String... importTaskIds) {
            importTaskIds(Arrays.asList(importTaskIds));
            return this;
        }

        public final void setImportTaskIds(Collection<String> importTaskIds) {
            this.importTaskIds = ImportTaskIdListCopier.copy(importTaskIds);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeImportSnapshotTasksRequest build() {
            return new DescribeImportSnapshotTasksRequest(this);
        }
    }
}
