/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A simple result wrapper around the ImageAttribute object that was sent over the wire.
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeImageAttributeResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeImageAttributeResponse.Builder, DescribeImageAttributeResponse> {
    private final ImageAttribute imageAttribute;

    private DescribeImageAttributeResponse(BuilderImpl builder) {
        this.imageAttribute = builder.imageAttribute;
    }

    /**
     * <p>
     * Describes an image attribute.
     * </p>
     * 
     * @return Describes an image attribute.
     */
    public ImageAttribute imageAttribute() {
        return imageAttribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageAttribute());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageAttributeResponse)) {
            return false;
        }
        DescribeImageAttributeResponse other = (DescribeImageAttributeResponse) obj;
        return Objects.equals(imageAttribute(), other.imageAttribute());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (imageAttribute() != null) {
            sb.append("ImageAttribute: ").append(imageAttribute()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageAttribute":
            return Optional.of(clazz.cast(imageAttribute()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeImageAttributeResponse> {
        /**
         * <p>
         * Describes an image attribute.
         * </p>
         * 
         * @param imageAttribute
         *        Describes an image attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageAttribute(ImageAttribute imageAttribute);

        /**
         * <p>
         * Describes an image attribute.
         * </p>
         * This is a convenience that creates an instance of the {@link ImageAttribute.Builder} avoiding the need to
         * create one manually via {@link ImageAttribute#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImageAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #imageAttribute(ImageAttribute)}.
         * 
         * @param imageAttribute
         *        a consumer that will call methods on {@link ImageAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageAttribute(ImageAttribute)
         */
        default Builder imageAttribute(Consumer<ImageAttribute.Builder> imageAttribute) {
            return imageAttribute(ImageAttribute.builder().apply(imageAttribute).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ImageAttribute imageAttribute;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageAttributeResponse model) {
            imageAttribute(model.imageAttribute);
        }

        public final ImageAttribute.Builder getImageAttribute() {
            return imageAttribute != null ? imageAttribute.toBuilder() : null;
        }

        @Override
        public final Builder imageAttribute(ImageAttribute imageAttribute) {
            this.imageAttribute = imageAttribute;
            return this;
        }

        public final void setImageAttribute(ImageAttribute.BuilderImpl imageAttribute) {
            this.imageAttribute = imageAttribute != null ? imageAttribute.build() : null;
        }

        @Override
        public DescribeImageAttributeResponse build() {
            return new DescribeImageAttributeResponse(this);
        }
    }
}
