/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DeleteNetworkInterface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteNetworkInterfaceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteNetworkInterfaceRequest.Builder, DeleteNetworkInterfaceRequest> {
    private final String networkInterfaceId;

    private DeleteNetworkInterfaceRequest(BuilderImpl builder) {
        this.networkInterfaceId = builder.networkInterfaceId;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteNetworkInterfaceRequest)) {
            return false;
        }
        DeleteNetworkInterfaceRequest other = (DeleteNetworkInterfaceRequest) obj;
        return Objects.equals(networkInterfaceId(), other.networkInterfaceId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(networkInterfaceId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInterfaceId":
            return Optional.of(clazz.cast(networkInterfaceId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteNetworkInterfaceRequest> {
        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);
    }

    static final class BuilderImpl implements Builder {
        private String networkInterfaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteNetworkInterfaceRequest model) {
            networkInterfaceId(model.networkInterfaceId);
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public DeleteNetworkInterfaceRequest build() {
            return new DeleteNetworkInterfaceRequest(this);
        }
    }
}
