/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateVpnConnection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateVpnConnectionResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateVpnConnectionResponse.Builder, CreateVpnConnectionResponse> {
    private final VpnConnection vpnConnection;

    private CreateVpnConnectionResponse(BuilderImpl builder) {
        this.vpnConnection = builder.vpnConnection;
    }

    /**
     * <p>
     * Information about the VPN connection.
     * </p>
     * 
     * @return Information about the VPN connection.
     */
    public VpnConnection vpnConnection() {
        return vpnConnection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpnConnection());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpnConnectionResponse)) {
            return false;
        }
        CreateVpnConnectionResponse other = (CreateVpnConnectionResponse) obj;
        return Objects.equals(vpnConnection(), other.vpnConnection());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (vpnConnection() != null) {
            sb.append("VpnConnection: ").append(vpnConnection()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpnConnection":
            return Optional.of(clazz.cast(vpnConnection()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateVpnConnectionResponse> {
        /**
         * <p>
         * Information about the VPN connection.
         * </p>
         * 
         * @param vpnConnection
         *        Information about the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnection(VpnConnection vpnConnection);

        /**
         * <p>
         * Information about the VPN connection.
         * </p>
         * This is a convenience that creates an instance of the {@link VpnConnection.Builder} avoiding the need to
         * create one manually via {@link VpnConnection#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpnConnection.Builder#build()} is called immediately and its
         * result is passed to {@link #vpnConnection(VpnConnection)}.
         * 
         * @param vpnConnection
         *        a consumer that will call methods on {@link VpnConnection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpnConnection(VpnConnection)
         */
        default Builder vpnConnection(Consumer<VpnConnection.Builder> vpnConnection) {
            return vpnConnection(VpnConnection.builder().apply(vpnConnection).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VpnConnection vpnConnection;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpnConnectionResponse model) {
            vpnConnection(model.vpnConnection);
        }

        public final VpnConnection.Builder getVpnConnection() {
            return vpnConnection != null ? vpnConnection.toBuilder() : null;
        }

        @Override
        public final Builder vpnConnection(VpnConnection vpnConnection) {
            this.vpnConnection = vpnConnection;
            return this;
        }

        public final void setVpnConnection(VpnConnection.BuilderImpl vpnConnection) {
            this.vpnConnection = vpnConnection != null ? vpnConnection.build() : null;
        }

        @Override
        public CreateVpnConnectionResponse build() {
            return new CreateVpnConnectionResponse(this);
        }
    }
}
