/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateDhcpOptions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDhcpOptionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateDhcpOptionsResponse.Builder, CreateDhcpOptionsResponse> {
    private final DhcpOptions dhcpOptions;

    private CreateDhcpOptionsResponse(BuilderImpl builder) {
        this.dhcpOptions = builder.dhcpOptions;
    }

    /**
     * <p>
     * A set of DHCP options.
     * </p>
     * 
     * @return A set of DHCP options.
     */
    public DhcpOptions dhcpOptions() {
        return dhcpOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dhcpOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDhcpOptionsResponse)) {
            return false;
        }
        CreateDhcpOptionsResponse other = (CreateDhcpOptionsResponse) obj;
        return Objects.equals(dhcpOptions(), other.dhcpOptions());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (dhcpOptions() != null) {
            sb.append("DhcpOptions: ").append(dhcpOptions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DhcpOptions":
            return Optional.of(clazz.cast(dhcpOptions()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateDhcpOptionsResponse> {
        /**
         * <p>
         * A set of DHCP options.
         * </p>
         * 
         * @param dhcpOptions
         *        A set of DHCP options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpOptions(DhcpOptions dhcpOptions);

        /**
         * <p>
         * A set of DHCP options.
         * </p>
         * This is a convenience that creates an instance of the {@link DhcpOptions.Builder} avoiding the need to create
         * one manually via {@link DhcpOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link DhcpOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #dhcpOptions(DhcpOptions)}.
         * 
         * @param dhcpOptions
         *        a consumer that will call methods on {@link DhcpOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dhcpOptions(DhcpOptions)
         */
        default Builder dhcpOptions(Consumer<DhcpOptions.Builder> dhcpOptions) {
            return dhcpOptions(DhcpOptions.builder().apply(dhcpOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DhcpOptions dhcpOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDhcpOptionsResponse model) {
            dhcpOptions(model.dhcpOptions);
        }

        public final DhcpOptions.Builder getDhcpOptions() {
            return dhcpOptions != null ? dhcpOptions.toBuilder() : null;
        }

        @Override
        public final Builder dhcpOptions(DhcpOptions dhcpOptions) {
            this.dhcpOptions = dhcpOptions;
            return this;
        }

        public final void setDhcpOptions(DhcpOptions.BuilderImpl dhcpOptions) {
            this.dhcpOptions = dhcpOptions != null ? dhcpOptions.build() : null;
        }

        @Override
        public CreateDhcpOptionsResponse build() {
            return new CreateDhcpOptionsResponse(this);
        }
    }
}
