/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of ConfirmProductInstance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ConfirmProductInstanceResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ConfirmProductInstanceResponse.Builder, ConfirmProductInstanceResponse> {
    private final String ownerId;

    private final Boolean returnValue;

    private ConfirmProductInstanceResponse(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.returnValue = builder.returnValue;
    }

    /**
     * <p>
     * The AWS account ID of the instance owner. This is only present if the product code is attached to the instance.
     * </p>
     * 
     * @return The AWS account ID of the instance owner. This is only present if the product code is attached to the
     *         instance.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The return value of the request. Returns <code>true</code> if the specified product code is owned by the
     * requester and associated with the specified instance.
     * </p>
     * 
     * @return The return value of the request. Returns <code>true</code> if the specified product code is owned by the
     *         requester and associated with the specified instance.
     */
    public Boolean returnValue() {
        return returnValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(returnValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfirmProductInstanceResponse)) {
            return false;
        }
        ConfirmProductInstanceResponse other = (ConfirmProductInstanceResponse) obj;
        return Objects.equals(ownerId(), other.ownerId()) && Objects.equals(returnValue(), other.returnValue());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (ownerId() != null) {
            sb.append("OwnerId: ").append(ownerId()).append(",");
        }
        if (returnValue() != null) {
            sb.append("ReturnValue: ").append(returnValue()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OwnerId":
            return Optional.of(clazz.cast(ownerId()));
        case "ReturnValue":
            return Optional.of(clazz.cast(returnValue()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ConfirmProductInstanceResponse> {
        /**
         * <p>
         * The AWS account ID of the instance owner. This is only present if the product code is attached to the
         * instance.
         * </p>
         * 
         * @param ownerId
         *        The AWS account ID of the instance owner. This is only present if the product code is attached to the
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The return value of the request. Returns <code>true</code> if the specified product code is owned by the
         * requester and associated with the specified instance.
         * </p>
         * 
         * @param returnValue
         *        The return value of the request. Returns <code>true</code> if the specified product code is owned by
         *        the requester and associated with the specified instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnValue(Boolean returnValue);
    }

    static final class BuilderImpl implements Builder {
        private String ownerId;

        private Boolean returnValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfirmProductInstanceResponse model) {
            ownerId(model.ownerId);
            returnValue(model.returnValue);
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final Boolean getReturnValue() {
            return returnValue;
        }

        @Override
        public final Builder returnValue(Boolean returnValue) {
            this.returnValue = returnValue;
            return this;
        }

        public final void setReturnValue(Boolean returnValue) {
            this.returnValue = returnValue;
        }

        @Override
        public ConfirmProductInstanceResponse build() {
            return new ConfirmProductInstanceResponse(this);
        }
    }
}
