/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CancelSpotInstanceRequests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CancelSpotInstanceRequestsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CancelSpotInstanceRequestsResponse.Builder, CancelSpotInstanceRequestsResponse> {
    private final List<CancelledSpotInstanceRequest> cancelledSpotInstanceRequests;

    private CancelSpotInstanceRequestsResponse(BuilderImpl builder) {
        this.cancelledSpotInstanceRequests = builder.cancelledSpotInstanceRequests;
    }

    /**
     * <p>
     * One or more Spot instance requests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more Spot instance requests.
     */
    public List<CancelledSpotInstanceRequest> cancelledSpotInstanceRequests() {
        return cancelledSpotInstanceRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cancelledSpotInstanceRequests());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotInstanceRequestsResponse)) {
            return false;
        }
        CancelSpotInstanceRequestsResponse other = (CancelSpotInstanceRequestsResponse) obj;
        return Objects.equals(cancelledSpotInstanceRequests(), other.cancelledSpotInstanceRequests());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (cancelledSpotInstanceRequests() != null) {
            sb.append("CancelledSpotInstanceRequests: ").append(cancelledSpotInstanceRequests()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CancelledSpotInstanceRequests":
            return Optional.of(clazz.cast(cancelledSpotInstanceRequests()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CancelSpotInstanceRequestsResponse> {
        /**
         * <p>
         * One or more Spot instance requests.
         * </p>
         * 
         * @param cancelledSpotInstanceRequests
         *        One or more Spot instance requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelledSpotInstanceRequests(Collection<CancelledSpotInstanceRequest> cancelledSpotInstanceRequests);

        /**
         * <p>
         * One or more Spot instance requests.
         * </p>
         * 
         * @param cancelledSpotInstanceRequests
         *        One or more Spot instance requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelledSpotInstanceRequests(CancelledSpotInstanceRequest... cancelledSpotInstanceRequests);
    }

    static final class BuilderImpl implements Builder {
        private List<CancelledSpotInstanceRequest> cancelledSpotInstanceRequests;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSpotInstanceRequestsResponse model) {
            cancelledSpotInstanceRequests(model.cancelledSpotInstanceRequests);
        }

        public final Collection<CancelledSpotInstanceRequest.Builder> getCancelledSpotInstanceRequests() {
            return cancelledSpotInstanceRequests != null ? cancelledSpotInstanceRequests.stream()
                    .map(CancelledSpotInstanceRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cancelledSpotInstanceRequests(Collection<CancelledSpotInstanceRequest> cancelledSpotInstanceRequests) {
            this.cancelledSpotInstanceRequests = CancelledSpotInstanceRequestListCopier.copy(cancelledSpotInstanceRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cancelledSpotInstanceRequests(CancelledSpotInstanceRequest... cancelledSpotInstanceRequests) {
            cancelledSpotInstanceRequests(Arrays.asList(cancelledSpotInstanceRequests));
            return this;
        }

        public final void setCancelledSpotInstanceRequests(
                Collection<CancelledSpotInstanceRequest.BuilderImpl> cancelledSpotInstanceRequests) {
            this.cancelledSpotInstanceRequests = CancelledSpotInstanceRequestListCopier
                    .copyFromBuilder(cancelledSpotInstanceRequests);
        }

        @Override
        public CancelSpotInstanceRequestsResponse build() {
            return new CancelSpotInstanceRequestsResponse(this);
        }
    }
}
