/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The capacity information for instances launched onto the Dedicated Host.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AvailableCapacity implements ToCopyableBuilder<AvailableCapacity.Builder, AvailableCapacity> {
    private final List<InstanceCapacity> availableInstanceCapacity;

    private final Integer availableVCpus;

    private AvailableCapacity(BuilderImpl builder) {
        this.availableInstanceCapacity = builder.availableInstanceCapacity;
        this.availableVCpus = builder.availableVCpus;
    }

    /**
     * <p>
     * The total number of instances that the Dedicated Host supports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The total number of instances that the Dedicated Host supports.
     */
    public List<InstanceCapacity> availableInstanceCapacity() {
        return availableInstanceCapacity;
    }

    /**
     * <p>
     * The number of vCPUs available on the Dedicated Host.
     * </p>
     * 
     * @return The number of vCPUs available on the Dedicated Host.
     */
    public Integer availableVCpus() {
        return availableVCpus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availableInstanceCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(availableVCpus());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailableCapacity)) {
            return false;
        }
        AvailableCapacity other = (AvailableCapacity) obj;
        return Objects.equals(availableInstanceCapacity(), other.availableInstanceCapacity())
                && Objects.equals(availableVCpus(), other.availableVCpus());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (availableInstanceCapacity() != null) {
            sb.append("AvailableInstanceCapacity: ").append(availableInstanceCapacity()).append(",");
        }
        if (availableVCpus() != null) {
            sb.append("AvailableVCpus: ").append(availableVCpus()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailableInstanceCapacity":
            return Optional.of(clazz.cast(availableInstanceCapacity()));
        case "AvailableVCpus":
            return Optional.of(clazz.cast(availableVCpus()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, AvailableCapacity> {
        /**
         * <p>
         * The total number of instances that the Dedicated Host supports.
         * </p>
         * 
         * @param availableInstanceCapacity
         *        The total number of instances that the Dedicated Host supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableInstanceCapacity(Collection<InstanceCapacity> availableInstanceCapacity);

        /**
         * <p>
         * The total number of instances that the Dedicated Host supports.
         * </p>
         * 
         * @param availableInstanceCapacity
         *        The total number of instances that the Dedicated Host supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableInstanceCapacity(InstanceCapacity... availableInstanceCapacity);

        /**
         * <p>
         * The number of vCPUs available on the Dedicated Host.
         * </p>
         * 
         * @param availableVCpus
         *        The number of vCPUs available on the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableVCpus(Integer availableVCpus);
    }

    static final class BuilderImpl implements Builder {
        private List<InstanceCapacity> availableInstanceCapacity;

        private Integer availableVCpus;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailableCapacity model) {
            availableInstanceCapacity(model.availableInstanceCapacity);
            availableVCpus(model.availableVCpus);
        }

        public final Collection<InstanceCapacity.Builder> getAvailableInstanceCapacity() {
            return availableInstanceCapacity != null ? availableInstanceCapacity.stream().map(InstanceCapacity::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder availableInstanceCapacity(Collection<InstanceCapacity> availableInstanceCapacity) {
            this.availableInstanceCapacity = AvailableInstanceCapacityListCopier.copy(availableInstanceCapacity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availableInstanceCapacity(InstanceCapacity... availableInstanceCapacity) {
            availableInstanceCapacity(Arrays.asList(availableInstanceCapacity));
            return this;
        }

        public final void setAvailableInstanceCapacity(Collection<InstanceCapacity.BuilderImpl> availableInstanceCapacity) {
            this.availableInstanceCapacity = AvailableInstanceCapacityListCopier.copyFromBuilder(availableInstanceCapacity);
        }

        public final Integer getAvailableVCpus() {
            return availableVCpus;
        }

        @Override
        public final Builder availableVCpus(Integer availableVCpus) {
            this.availableVCpus = availableVCpus;
            return this;
        }

        public final void setAvailableVCpus(Integer availableVCpus) {
            this.availableVCpus = availableVCpus;
        }

        @Override
        public AvailableCapacity build() {
            return new AvailableCapacity(this);
        }
    }
}
