/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.ResetSnapshotAttributeRequest;

public class ResetSnapshotAttributeRequestMarshaller
implements Marshaller<Request<ResetSnapshotAttributeRequest>, ResetSnapshotAttributeRequest> {
    public Request<ResetSnapshotAttributeRequest> marshall(ResetSnapshotAttributeRequest resetSnapshotAttributeRequest) {
        if (resetSnapshotAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)resetSnapshotAttributeRequest, "EC2Client");
        request.addParameter("Action", "ResetSnapshotAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (resetSnapshotAttributeRequest.attributeString() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)resetSnapshotAttributeRequest.attributeString()));
        }
        if (resetSnapshotAttributeRequest.snapshotId() != null) {
            request.addParameter("SnapshotId", StringUtils.fromString((String)resetSnapshotAttributeRequest.snapshotId()));
        }
        return request;
    }
}

