/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.GetConsoleScreenshotRequest;

public class GetConsoleScreenshotRequestMarshaller
implements Marshaller<Request<GetConsoleScreenshotRequest>, GetConsoleScreenshotRequest> {
    public Request<GetConsoleScreenshotRequest> marshall(GetConsoleScreenshotRequest getConsoleScreenshotRequest) {
        if (getConsoleScreenshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getConsoleScreenshotRequest, "EC2Client");
        request.addParameter("Action", "GetConsoleScreenshot");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (getConsoleScreenshotRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)getConsoleScreenshotRequest.instanceId()));
        }
        if (getConsoleScreenshotRequest.wakeUp() != null) {
            request.addParameter("WakeUp", StringUtils.fromBoolean((Boolean)getConsoleScreenshotRequest.wakeUp()));
        }
        return request;
    }
}

