/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.EnableVolumeIORequest;

public class EnableVolumeIORequestMarshaller
implements Marshaller<Request<EnableVolumeIORequest>, EnableVolumeIORequest> {
    public Request<EnableVolumeIORequest> marshall(EnableVolumeIORequest enableVolumeIORequest) {
        if (enableVolumeIORequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)enableVolumeIORequest, "EC2Client");
        request.addParameter("Action", "EnableVolumeIO");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (enableVolumeIORequest.volumeId() != null) {
            request.addParameter("VolumeId", StringUtils.fromString((String)enableVolumeIORequest.volumeId()));
        }
        return request;
    }
}

