/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DetachInternetGatewayRequest;

public class DetachInternetGatewayRequestMarshaller
implements Marshaller<Request<DetachInternetGatewayRequest>, DetachInternetGatewayRequest> {
    public Request<DetachInternetGatewayRequest> marshall(DetachInternetGatewayRequest detachInternetGatewayRequest) {
        if (detachInternetGatewayRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)detachInternetGatewayRequest, "EC2Client");
        request.addParameter("Action", "DetachInternetGateway");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (detachInternetGatewayRequest.internetGatewayId() != null) {
            request.addParameter("InternetGatewayId", StringUtils.fromString((String)detachInternetGatewayRequest.internetGatewayId()));
        }
        if (detachInternetGatewayRequest.vpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)detachInternetGatewayRequest.vpcId()));
        }
        return request;
    }
}

