/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointsRequest;

public class DeleteVpcEndpointsRequestMarshaller
implements Marshaller<Request<DeleteVpcEndpointsRequest>, DeleteVpcEndpointsRequest> {
    public Request<DeleteVpcEndpointsRequest> marshall(DeleteVpcEndpointsRequest deleteVpcEndpointsRequest) {
        if (deleteVpcEndpointsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteVpcEndpointsRequest, "EC2Client");
        request.addParameter("Action", "DeleteVpcEndpoints");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> deleteVpcEndpointsRequestVpcEndpointIdsList = deleteVpcEndpointsRequest.vpcEndpointIds();
        if (deleteVpcEndpointsRequestVpcEndpointIdsList != null) {
            int vpcEndpointIdsListIndex = 1;
            for (String deleteVpcEndpointsRequestVpcEndpointIdsListValue : deleteVpcEndpointsRequestVpcEndpointIdsList) {
                if (deleteVpcEndpointsRequestVpcEndpointIdsListValue != null) {
                    request.addParameter("VpcEndpointId." + vpcEndpointIdsListIndex, StringUtils.fromString((String)deleteVpcEndpointsRequestVpcEndpointIdsListValue));
                }
                ++vpcEndpointIdsListIndex;
            }
        }
        return request;
    }
}

