/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.AttachInternetGatewayRequest;

public class AttachInternetGatewayRequestMarshaller
implements Marshaller<Request<AttachInternetGatewayRequest>, AttachInternetGatewayRequest> {
    public Request<AttachInternetGatewayRequest> marshall(AttachInternetGatewayRequest attachInternetGatewayRequest) {
        if (attachInternetGatewayRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)attachInternetGatewayRequest, "EC2Client");
        request.addParameter("Action", "AttachInternetGateway");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (attachInternetGatewayRequest.internetGatewayId() != null) {
            request.addParameter("InternetGatewayId", StringUtils.fromString((String)attachInternetGatewayRequest.internetGatewayId()));
        }
        if (attachInternetGatewayRequest.vpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)attachInternetGatewayRequest.vpcId()));
        }
        return request;
    }
}

