/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.GatewayType;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.VgwTelemetry;
import software.amazon.awssdk.services.ec2.model.VgwTelemetryListCopier;
import software.amazon.awssdk.services.ec2.model.VpnConnectionOptions;
import software.amazon.awssdk.services.ec2.model.VpnState;
import software.amazon.awssdk.services.ec2.model.VpnStaticRoute;
import software.amazon.awssdk.services.ec2.model.VpnStaticRouteListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VpnConnection
implements ToCopyableBuilder<Builder, VpnConnection> {
    private final String customerGatewayConfiguration;
    private final String customerGatewayId;
    private final String state;
    private final String type;
    private final String vpnConnectionId;
    private final String vpnGatewayId;
    private final VpnConnectionOptions options;
    private final List<VpnStaticRoute> routes;
    private final List<Tag> tags;
    private final List<VgwTelemetry> vgwTelemetry;

    private VpnConnection(BuilderImpl builder) {
        this.customerGatewayConfiguration = builder.customerGatewayConfiguration;
        this.customerGatewayId = builder.customerGatewayId;
        this.state = builder.state;
        this.type = builder.type;
        this.vpnConnectionId = builder.vpnConnectionId;
        this.vpnGatewayId = builder.vpnGatewayId;
        this.options = builder.options;
        this.routes = builder.routes;
        this.tags = builder.tags;
        this.vgwTelemetry = builder.vgwTelemetry;
    }

    public String customerGatewayConfiguration() {
        return this.customerGatewayConfiguration;
    }

    public String customerGatewayId() {
        return this.customerGatewayId;
    }

    public VpnState state() {
        return VpnState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public GatewayType type() {
        return GatewayType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public String vpnConnectionId() {
        return this.vpnConnectionId;
    }

    public String vpnGatewayId() {
        return this.vpnGatewayId;
    }

    public VpnConnectionOptions options() {
        return this.options;
    }

    public List<VpnStaticRoute> routes() {
        return this.routes;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public List<VgwTelemetry> vgwTelemetry() {
        return this.vgwTelemetry;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.customerGatewayConfiguration() == null ? 0 : this.customerGatewayConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.customerGatewayId() == null ? 0 : this.customerGatewayId().hashCode());
        hashCode = 31 * hashCode + (this.stateString() == null ? 0 : this.stateString().hashCode());
        hashCode = 31 * hashCode + (this.typeString() == null ? 0 : this.typeString().hashCode());
        hashCode = 31 * hashCode + (this.vpnConnectionId() == null ? 0 : this.vpnConnectionId().hashCode());
        hashCode = 31 * hashCode + (this.vpnGatewayId() == null ? 0 : this.vpnGatewayId().hashCode());
        hashCode = 31 * hashCode + (this.options() == null ? 0 : this.options().hashCode());
        hashCode = 31 * hashCode + (this.routes() == null ? 0 : this.routes().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.vgwTelemetry() == null ? 0 : this.vgwTelemetry().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnConnection)) {
            return false;
        }
        VpnConnection other = (VpnConnection)obj;
        if (other.customerGatewayConfiguration() == null ^ this.customerGatewayConfiguration() == null) {
            return false;
        }
        if (other.customerGatewayConfiguration() != null && !other.customerGatewayConfiguration().equals(this.customerGatewayConfiguration())) {
            return false;
        }
        if (other.customerGatewayId() == null ^ this.customerGatewayId() == null) {
            return false;
        }
        if (other.customerGatewayId() != null && !other.customerGatewayId().equals(this.customerGatewayId())) {
            return false;
        }
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        if (other.stateString() != null && !other.stateString().equals(this.stateString())) {
            return false;
        }
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.vpnConnectionId() == null ^ this.vpnConnectionId() == null) {
            return false;
        }
        if (other.vpnConnectionId() != null && !other.vpnConnectionId().equals(this.vpnConnectionId())) {
            return false;
        }
        if (other.vpnGatewayId() == null ^ this.vpnGatewayId() == null) {
            return false;
        }
        if (other.vpnGatewayId() != null && !other.vpnGatewayId().equals(this.vpnGatewayId())) {
            return false;
        }
        if (other.options() == null ^ this.options() == null) {
            return false;
        }
        if (other.options() != null && !other.options().equals(this.options())) {
            return false;
        }
        if (other.routes() == null ^ this.routes() == null) {
            return false;
        }
        if (other.routes() != null && !other.routes().equals(this.routes())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.vgwTelemetry() == null ^ this.vgwTelemetry() == null) {
            return false;
        }
        return other.vgwTelemetry() == null || other.vgwTelemetry().equals(this.vgwTelemetry());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.customerGatewayConfiguration() != null) {
            sb.append("CustomerGatewayConfiguration: ").append(this.customerGatewayConfiguration()).append(",");
        }
        if (this.customerGatewayId() != null) {
            sb.append("CustomerGatewayId: ").append(this.customerGatewayId()).append(",");
        }
        if (this.stateString() != null) {
            sb.append("State: ").append(this.stateString()).append(",");
        }
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.vpnConnectionId() != null) {
            sb.append("VpnConnectionId: ").append(this.vpnConnectionId()).append(",");
        }
        if (this.vpnGatewayId() != null) {
            sb.append("VpnGatewayId: ").append(this.vpnGatewayId()).append(",");
        }
        if (this.options() != null) {
            sb.append("Options: ").append(this.options()).append(",");
        }
        if (this.routes() != null) {
            sb.append("Routes: ").append(this.routes()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.vgwTelemetry() != null) {
            sb.append("VgwTelemetry: ").append(this.vgwTelemetry()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomerGatewayConfiguration": {
                return Optional.of(clazz.cast(this.customerGatewayConfiguration()));
            }
            case "CustomerGatewayId": {
                return Optional.of(clazz.cast(this.customerGatewayId()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "VpnConnectionId": {
                return Optional.of(clazz.cast(this.vpnConnectionId()));
            }
            case "VpnGatewayId": {
                return Optional.of(clazz.cast(this.vpnGatewayId()));
            }
            case "Options": {
                return Optional.of(clazz.cast(this.options()));
            }
            case "Routes": {
                return Optional.of(clazz.cast(this.routes()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "VgwTelemetry": {
                return Optional.of(clazz.cast(this.vgwTelemetry()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String customerGatewayConfiguration;
        private String customerGatewayId;
        private String state;
        private String type;
        private String vpnConnectionId;
        private String vpnGatewayId;
        private VpnConnectionOptions options;
        private List<VpnStaticRoute> routes;
        private List<Tag> tags;
        private List<VgwTelemetry> vgwTelemetry;

        private BuilderImpl() {
        }

        private BuilderImpl(VpnConnection model) {
            this.customerGatewayConfiguration(model.customerGatewayConfiguration);
            this.customerGatewayId(model.customerGatewayId);
            this.state(model.state);
            this.type(model.type);
            this.vpnConnectionId(model.vpnConnectionId);
            this.vpnGatewayId(model.vpnGatewayId);
            this.options(model.options);
            this.routes(model.routes);
            this.tags(model.tags);
            this.vgwTelemetry(model.vgwTelemetry);
        }

        public final String getCustomerGatewayConfiguration() {
            return this.customerGatewayConfiguration;
        }

        @Override
        public final Builder customerGatewayConfiguration(String customerGatewayConfiguration) {
            this.customerGatewayConfiguration = customerGatewayConfiguration;
            return this;
        }

        public final void setCustomerGatewayConfiguration(String customerGatewayConfiguration) {
            this.customerGatewayConfiguration = customerGatewayConfiguration;
        }

        public final String getCustomerGatewayId() {
            return this.customerGatewayId;
        }

        @Override
        public final Builder customerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
            return this;
        }

        public final void setCustomerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpnState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GatewayType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getVpnConnectionId() {
            return this.vpnConnectionId;
        }

        @Override
        public final Builder vpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
            return this;
        }

        public final void setVpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
        }

        public final String getVpnGatewayId() {
            return this.vpnGatewayId;
        }

        @Override
        public final Builder vpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        public final void setVpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
        }

        public final VpnConnectionOptions.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        @Override
        public final Builder options(VpnConnectionOptions options) {
            this.options = options;
            return this;
        }

        public final void setOptions(VpnConnectionOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        public final Collection<VpnStaticRoute.Builder> getRoutes() {
            return this.routes != null ? (Collection)this.routes.stream().map(VpnStaticRoute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder routes(Collection<VpnStaticRoute> routes) {
            this.routes = VpnStaticRouteListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(VpnStaticRoute ... routes) {
            this.routes(Arrays.asList(routes));
            return this;
        }

        public final void setRoutes(Collection<VpnStaticRoute.BuilderImpl> routes) {
            this.routes = VpnStaticRouteListCopier.copyFromBuilder(routes);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Collection<VgwTelemetry.Builder> getVgwTelemetry() {
            return this.vgwTelemetry != null ? (Collection)this.vgwTelemetry.stream().map(VgwTelemetry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vgwTelemetry(Collection<VgwTelemetry> vgwTelemetry) {
            this.vgwTelemetry = VgwTelemetryListCopier.copy(vgwTelemetry);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vgwTelemetry(VgwTelemetry ... vgwTelemetry) {
            this.vgwTelemetry(Arrays.asList(vgwTelemetry));
            return this;
        }

        public final void setVgwTelemetry(Collection<VgwTelemetry.BuilderImpl> vgwTelemetry) {
            this.vgwTelemetry = VgwTelemetryListCopier.copyFromBuilder(vgwTelemetry);
        }

        public VpnConnection build() {
            return new VpnConnection(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VpnConnection> {
        public Builder customerGatewayConfiguration(String var1);

        public Builder customerGatewayId(String var1);

        public Builder state(String var1);

        public Builder state(VpnState var1);

        public Builder type(String var1);

        public Builder type(GatewayType var1);

        public Builder vpnConnectionId(String var1);

        public Builder vpnGatewayId(String var1);

        public Builder options(VpnConnectionOptions var1);

        public Builder routes(Collection<VpnStaticRoute> var1);

        public Builder routes(VpnStaticRoute ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder vgwTelemetry(Collection<VgwTelemetry> var1);

        public Builder vgwTelemetry(VgwTelemetry ... var1);
    }
}

