/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.VpcCidrBlockStateCode;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VpcCidrBlockState
implements ToCopyableBuilder<Builder, VpcCidrBlockState> {
    private final String state;
    private final String statusMessage;

    private VpcCidrBlockState(BuilderImpl builder) {
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
    }

    public VpcCidrBlockStateCode state() {
        return VpcCidrBlockStateCode.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stateString() == null ? 0 : this.stateString().hashCode());
        hashCode = 31 * hashCode + (this.statusMessage() == null ? 0 : this.statusMessage().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcCidrBlockState)) {
            return false;
        }
        VpcCidrBlockState other = (VpcCidrBlockState)obj;
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        if (other.stateString() != null && !other.stateString().equals(this.stateString())) {
            return false;
        }
        if (other.statusMessage() == null ^ this.statusMessage() == null) {
            return false;
        }
        return other.statusMessage() == null || other.statusMessage().equals(this.statusMessage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stateString() != null) {
            sb.append("State: ").append(this.stateString()).append(",");
        }
        if (this.statusMessage() != null) {
            sb.append("StatusMessage: ").append(this.statusMessage()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "StatusMessage": {
                return Optional.of(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcCidrBlockState model) {
            this.state(model.state);
            this.statusMessage(model.statusMessage);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpcCidrBlockStateCode state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public VpcCidrBlockState build() {
            return new VpcCidrBlockState(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VpcCidrBlockState> {
        public Builder state(String var1);

        public Builder state(VpcCidrBlockStateCode var1);

        public Builder statusMessage(String var1);
    }
}

