/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.ReservationValue;
import software.amazon.awssdk.services.ec2.model.TargetConfiguration;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TargetReservationValue
implements ToCopyableBuilder<Builder, TargetReservationValue> {
    private final ReservationValue reservationValue;
    private final TargetConfiguration targetConfiguration;

    private TargetReservationValue(BuilderImpl builder) {
        this.reservationValue = builder.reservationValue;
        this.targetConfiguration = builder.targetConfiguration;
    }

    public ReservationValue reservationValue() {
        return this.reservationValue;
    }

    public TargetConfiguration targetConfiguration() {
        return this.targetConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.reservationValue() == null ? 0 : this.reservationValue().hashCode());
        hashCode = 31 * hashCode + (this.targetConfiguration() == null ? 0 : this.targetConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetReservationValue)) {
            return false;
        }
        TargetReservationValue other = (TargetReservationValue)obj;
        if (other.reservationValue() == null ^ this.reservationValue() == null) {
            return false;
        }
        if (other.reservationValue() != null && !other.reservationValue().equals(this.reservationValue())) {
            return false;
        }
        if (other.targetConfiguration() == null ^ this.targetConfiguration() == null) {
            return false;
        }
        return other.targetConfiguration() == null || other.targetConfiguration().equals(this.targetConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.reservationValue() != null) {
            sb.append("ReservationValue: ").append(this.reservationValue()).append(",");
        }
        if (this.targetConfiguration() != null) {
            sb.append("TargetConfiguration: ").append(this.targetConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservationValue": {
                return Optional.of(clazz.cast(this.reservationValue()));
            }
            case "TargetConfiguration": {
                return Optional.of(clazz.cast(this.targetConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private ReservationValue reservationValue;
        private TargetConfiguration targetConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetReservationValue model) {
            this.reservationValue(model.reservationValue);
            this.targetConfiguration(model.targetConfiguration);
        }

        public final ReservationValue.Builder getReservationValue() {
            return this.reservationValue != null ? this.reservationValue.toBuilder() : null;
        }

        @Override
        public final Builder reservationValue(ReservationValue reservationValue) {
            this.reservationValue = reservationValue;
            return this;
        }

        public final void setReservationValue(ReservationValue.BuilderImpl reservationValue) {
            this.reservationValue = reservationValue != null ? reservationValue.build() : null;
        }

        public final TargetConfiguration.Builder getTargetConfiguration() {
            return this.targetConfiguration != null ? this.targetConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder targetConfiguration(TargetConfiguration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        public final void setTargetConfiguration(TargetConfiguration.BuilderImpl targetConfiguration) {
            this.targetConfiguration = targetConfiguration != null ? targetConfiguration.build() : null;
        }

        public TargetReservationValue build() {
            return new TargetReservationValue(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TargetReservationValue> {
        public Builder reservationValue(ReservationValue var1);

        public Builder targetConfiguration(TargetConfiguration var1);
    }
}

