/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.DatafeedSubscriptionState;
import software.amazon.awssdk.services.ec2.model.SpotInstanceStateFault;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SpotDatafeedSubscription
implements ToCopyableBuilder<Builder, SpotDatafeedSubscription> {
    private final String bucket;
    private final SpotInstanceStateFault fault;
    private final String ownerId;
    private final String prefix;
    private final String state;

    private SpotDatafeedSubscription(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.fault = builder.fault;
        this.ownerId = builder.ownerId;
        this.prefix = builder.prefix;
        this.state = builder.state;
    }

    public String bucket() {
        return this.bucket;
    }

    public SpotInstanceStateFault fault() {
        return this.fault;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String prefix() {
        return this.prefix;
    }

    public DatafeedSubscriptionState state() {
        return DatafeedSubscriptionState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bucket() == null ? 0 : this.bucket().hashCode());
        hashCode = 31 * hashCode + (this.fault() == null ? 0 : this.fault().hashCode());
        hashCode = 31 * hashCode + (this.ownerId() == null ? 0 : this.ownerId().hashCode());
        hashCode = 31 * hashCode + (this.prefix() == null ? 0 : this.prefix().hashCode());
        hashCode = 31 * hashCode + (this.stateString() == null ? 0 : this.stateString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotDatafeedSubscription)) {
            return false;
        }
        SpotDatafeedSubscription other = (SpotDatafeedSubscription)obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.fault() == null ^ this.fault() == null) {
            return false;
        }
        if (other.fault() != null && !other.fault().equals(this.fault())) {
            return false;
        }
        if (other.ownerId() == null ^ this.ownerId() == null) {
            return false;
        }
        if (other.ownerId() != null && !other.ownerId().equals(this.ownerId())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        return other.stateString() == null || other.stateString().equals(this.stateString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.fault() != null) {
            sb.append("Fault: ").append(this.fault()).append(",");
        }
        if (this.ownerId() != null) {
            sb.append("OwnerId: ").append(this.ownerId()).append(",");
        }
        if (this.prefix() != null) {
            sb.append("Prefix: ").append(this.prefix()).append(",");
        }
        if (this.stateString() != null) {
            sb.append("State: ").append(this.stateString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.of(clazz.cast(this.bucket()));
            }
            case "Fault": {
                return Optional.of(clazz.cast(this.fault()));
            }
            case "OwnerId": {
                return Optional.of(clazz.cast(this.ownerId()));
            }
            case "Prefix": {
                return Optional.of(clazz.cast(this.prefix()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private SpotInstanceStateFault fault;
        private String ownerId;
        private String prefix;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotDatafeedSubscription model) {
            this.bucket(model.bucket);
            this.fault(model.fault);
            this.ownerId(model.ownerId);
            this.prefix(model.prefix);
            this.state(model.state);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final SpotInstanceStateFault.Builder getFault() {
            return this.fault != null ? this.fault.toBuilder() : null;
        }

        @Override
        public final Builder fault(SpotInstanceStateFault fault) {
            this.fault = fault;
            return this;
        }

        public final void setFault(SpotInstanceStateFault.BuilderImpl fault) {
            this.fault = fault != null ? fault.build() : null;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DatafeedSubscriptionState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public SpotDatafeedSubscription build() {
            return new SpotDatafeedSubscription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SpotDatafeedSubscription> {
        public Builder bucket(String var1);

        public Builder fault(SpotInstanceStateFault var1);

        public Builder ownerId(String var1);

        public Builder prefix(String var1);

        public Builder state(String var1);

        public Builder state(DatafeedSubscriptionState var1);
    }
}

