/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.IpPermission;
import software.amazon.awssdk.services.ec2.model.IpPermissionListCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SecurityGroup
implements ToCopyableBuilder<Builder, SecurityGroup> {
    private final String description;
    private final String groupName;
    private final List<IpPermission> ipPermissions;
    private final String ownerId;
    private final String groupId;
    private final List<IpPermission> ipPermissionsEgress;
    private final List<Tag> tags;
    private final String vpcId;

    private SecurityGroup(BuilderImpl builder) {
        this.description = builder.description;
        this.groupName = builder.groupName;
        this.ipPermissions = builder.ipPermissions;
        this.ownerId = builder.ownerId;
        this.groupId = builder.groupId;
        this.ipPermissionsEgress = builder.ipPermissionsEgress;
        this.tags = builder.tags;
        this.vpcId = builder.vpcId;
    }

    public String description() {
        return this.description;
    }

    public String groupName() {
        return this.groupName;
    }

    public List<IpPermission> ipPermissions() {
        return this.ipPermissions;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String groupId() {
        return this.groupId;
    }

    public List<IpPermission> ipPermissionsEgress() {
        return this.ipPermissionsEgress;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.groupName() == null ? 0 : this.groupName().hashCode());
        hashCode = 31 * hashCode + (this.ipPermissions() == null ? 0 : this.ipPermissions().hashCode());
        hashCode = 31 * hashCode + (this.ownerId() == null ? 0 : this.ownerId().hashCode());
        hashCode = 31 * hashCode + (this.groupId() == null ? 0 : this.groupId().hashCode());
        hashCode = 31 * hashCode + (this.ipPermissionsEgress() == null ? 0 : this.ipPermissionsEgress().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroup)) {
            return false;
        }
        SecurityGroup other = (SecurityGroup)obj;
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.groupName() == null ^ this.groupName() == null) {
            return false;
        }
        if (other.groupName() != null && !other.groupName().equals(this.groupName())) {
            return false;
        }
        if (other.ipPermissions() == null ^ this.ipPermissions() == null) {
            return false;
        }
        if (other.ipPermissions() != null && !other.ipPermissions().equals(this.ipPermissions())) {
            return false;
        }
        if (other.ownerId() == null ^ this.ownerId() == null) {
            return false;
        }
        if (other.ownerId() != null && !other.ownerId().equals(this.ownerId())) {
            return false;
        }
        if (other.groupId() == null ^ this.groupId() == null) {
            return false;
        }
        if (other.groupId() != null && !other.groupId().equals(this.groupId())) {
            return false;
        }
        if (other.ipPermissionsEgress() == null ^ this.ipPermissionsEgress() == null) {
            return false;
        }
        if (other.ipPermissionsEgress() != null && !other.ipPermissionsEgress().equals(this.ipPermissionsEgress())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        return other.vpcId() == null || other.vpcId().equals(this.vpcId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.groupName() != null) {
            sb.append("GroupName: ").append(this.groupName()).append(",");
        }
        if (this.ipPermissions() != null) {
            sb.append("IpPermissions: ").append(this.ipPermissions()).append(",");
        }
        if (this.ownerId() != null) {
            sb.append("OwnerId: ").append(this.ownerId()).append(",");
        }
        if (this.groupId() != null) {
            sb.append("GroupId: ").append(this.groupId()).append(",");
        }
        if (this.ipPermissionsEgress() != null) {
            sb.append("IpPermissionsEgress: ").append(this.ipPermissionsEgress()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "GroupName": {
                return Optional.of(clazz.cast(this.groupName()));
            }
            case "IpPermissions": {
                return Optional.of(clazz.cast(this.ipPermissions()));
            }
            case "OwnerId": {
                return Optional.of(clazz.cast(this.ownerId()));
            }
            case "GroupId": {
                return Optional.of(clazz.cast(this.groupId()));
            }
            case "IpPermissionsEgress": {
                return Optional.of(clazz.cast(this.ipPermissionsEgress()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String groupName;
        private List<IpPermission> ipPermissions;
        private String ownerId;
        private String groupId;
        private List<IpPermission> ipPermissionsEgress;
        private List<Tag> tags;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityGroup model) {
            this.description(model.description);
            this.groupName(model.groupName);
            this.ipPermissions(model.ipPermissions);
            this.ownerId(model.ownerId);
            this.groupId(model.groupId);
            this.ipPermissionsEgress(model.ipPermissionsEgress);
            this.tags(model.tags);
            this.vpcId(model.vpcId);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final Collection<IpPermission.Builder> getIpPermissions() {
            return this.ipPermissions != null ? (Collection)this.ipPermissions.stream().map(IpPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipPermissions(Collection<IpPermission> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copy(ipPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(IpPermission ... ipPermissions) {
            this.ipPermissions(Arrays.asList(ipPermissions));
            return this;
        }

        public final void setIpPermissions(Collection<IpPermission.BuilderImpl> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copyFromBuilder(ipPermissions);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final Collection<IpPermission.Builder> getIpPermissionsEgress() {
            return this.ipPermissionsEgress != null ? (Collection)this.ipPermissionsEgress.stream().map(IpPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipPermissionsEgress(Collection<IpPermission> ipPermissionsEgress) {
            this.ipPermissionsEgress = IpPermissionListCopier.copy(ipPermissionsEgress);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissionsEgress(IpPermission ... ipPermissionsEgress) {
            this.ipPermissionsEgress(Arrays.asList(ipPermissionsEgress));
            return this;
        }

        public final void setIpPermissionsEgress(Collection<IpPermission.BuilderImpl> ipPermissionsEgress) {
            this.ipPermissionsEgress = IpPermissionListCopier.copyFromBuilder(ipPermissionsEgress);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public SecurityGroup build() {
            return new SecurityGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SecurityGroup> {
        public Builder description(String var1);

        public Builder groupName(String var1);

        public Builder ipPermissions(Collection<IpPermission> var1);

        public Builder ipPermissions(IpPermission ... var1);

        public Builder ownerId(String var1);

        public Builder groupId(String var1);

        public Builder ipPermissionsEgress(Collection<IpPermission> var1);

        public Builder ipPermissionsEgress(IpPermission ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder vpcId(String var1);
    }
}

