/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.OfferingClassType;
import software.amazon.awssdk.services.ec2.model.OfferingTypeValues;
import software.amazon.awssdk.services.ec2.model.PricingDetail;
import software.amazon.awssdk.services.ec2.model.PricingDetailsListCopier;
import software.amazon.awssdk.services.ec2.model.RIProductDescription;
import software.amazon.awssdk.services.ec2.model.RecurringCharge;
import software.amazon.awssdk.services.ec2.model.RecurringChargesListCopier;
import software.amazon.awssdk.services.ec2.model.Scope;
import software.amazon.awssdk.services.ec2.model.Tenancy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReservedInstancesOffering
implements ToCopyableBuilder<Builder, ReservedInstancesOffering> {
    private final String availabilityZone;
    private final Long duration;
    private final Float fixedPrice;
    private final String instanceType;
    private final String productDescription;
    private final String reservedInstancesOfferingId;
    private final Float usagePrice;
    private final String currencyCode;
    private final String instanceTenancy;
    private final Boolean marketplace;
    private final String offeringClass;
    private final String offeringType;
    private final List<PricingDetail> pricingDetails;
    private final List<RecurringCharge> recurringCharges;
    private final String scope;

    private ReservedInstancesOffering(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.instanceType = builder.instanceType;
        this.productDescription = builder.productDescription;
        this.reservedInstancesOfferingId = builder.reservedInstancesOfferingId;
        this.usagePrice = builder.usagePrice;
        this.currencyCode = builder.currencyCode;
        this.instanceTenancy = builder.instanceTenancy;
        this.marketplace = builder.marketplace;
        this.offeringClass = builder.offeringClass;
        this.offeringType = builder.offeringType;
        this.pricingDetails = builder.pricingDetails;
        this.recurringCharges = builder.recurringCharges;
        this.scope = builder.scope;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Long duration() {
        return this.duration;
    }

    public Float fixedPrice() {
        return this.fixedPrice;
    }

    public InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeString() {
        return this.instanceType;
    }

    public RIProductDescription productDescription() {
        return RIProductDescription.fromValue(this.productDescription);
    }

    public String productDescriptionString() {
        return this.productDescription;
    }

    public String reservedInstancesOfferingId() {
        return this.reservedInstancesOfferingId;
    }

    public Float usagePrice() {
        return this.usagePrice;
    }

    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(this.currencyCode);
    }

    public String currencyCodeString() {
        return this.currencyCode;
    }

    public Tenancy instanceTenancy() {
        return Tenancy.fromValue(this.instanceTenancy);
    }

    public String instanceTenancyString() {
        return this.instanceTenancy;
    }

    public Boolean marketplace() {
        return this.marketplace;
    }

    public OfferingClassType offeringClass() {
        return OfferingClassType.fromValue(this.offeringClass);
    }

    public String offeringClassString() {
        return this.offeringClass;
    }

    public OfferingTypeValues offeringType() {
        return OfferingTypeValues.fromValue(this.offeringType);
    }

    public String offeringTypeString() {
        return this.offeringType;
    }

    public List<PricingDetail> pricingDetails() {
        return this.pricingDetails;
    }

    public List<RecurringCharge> recurringCharges() {
        return this.recurringCharges;
    }

    public Scope scope() {
        return Scope.fromValue(this.scope);
    }

    public String scopeString() {
        return this.scope;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.duration() == null ? 0 : this.duration().hashCode());
        hashCode = 31 * hashCode + (this.fixedPrice() == null ? 0 : this.fixedPrice().hashCode());
        hashCode = 31 * hashCode + (this.instanceTypeString() == null ? 0 : this.instanceTypeString().hashCode());
        hashCode = 31 * hashCode + (this.productDescriptionString() == null ? 0 : this.productDescriptionString().hashCode());
        hashCode = 31 * hashCode + (this.reservedInstancesOfferingId() == null ? 0 : this.reservedInstancesOfferingId().hashCode());
        hashCode = 31 * hashCode + (this.usagePrice() == null ? 0 : this.usagePrice().hashCode());
        hashCode = 31 * hashCode + (this.currencyCodeString() == null ? 0 : this.currencyCodeString().hashCode());
        hashCode = 31 * hashCode + (this.instanceTenancyString() == null ? 0 : this.instanceTenancyString().hashCode());
        hashCode = 31 * hashCode + (this.marketplace() == null ? 0 : this.marketplace().hashCode());
        hashCode = 31 * hashCode + (this.offeringClassString() == null ? 0 : this.offeringClassString().hashCode());
        hashCode = 31 * hashCode + (this.offeringTypeString() == null ? 0 : this.offeringTypeString().hashCode());
        hashCode = 31 * hashCode + (this.pricingDetails() == null ? 0 : this.pricingDetails().hashCode());
        hashCode = 31 * hashCode + (this.recurringCharges() == null ? 0 : this.recurringCharges().hashCode());
        hashCode = 31 * hashCode + (this.scopeString() == null ? 0 : this.scopeString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesOffering)) {
            return false;
        }
        ReservedInstancesOffering other = (ReservedInstancesOffering)obj;
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.duration() == null ^ this.duration() == null) {
            return false;
        }
        if (other.duration() != null && !other.duration().equals(this.duration())) {
            return false;
        }
        if (other.fixedPrice() == null ^ this.fixedPrice() == null) {
            return false;
        }
        if (other.fixedPrice() != null && !other.fixedPrice().equals(this.fixedPrice())) {
            return false;
        }
        if (other.instanceTypeString() == null ^ this.instanceTypeString() == null) {
            return false;
        }
        if (other.instanceTypeString() != null && !other.instanceTypeString().equals(this.instanceTypeString())) {
            return false;
        }
        if (other.productDescriptionString() == null ^ this.productDescriptionString() == null) {
            return false;
        }
        if (other.productDescriptionString() != null && !other.productDescriptionString().equals(this.productDescriptionString())) {
            return false;
        }
        if (other.reservedInstancesOfferingId() == null ^ this.reservedInstancesOfferingId() == null) {
            return false;
        }
        if (other.reservedInstancesOfferingId() != null && !other.reservedInstancesOfferingId().equals(this.reservedInstancesOfferingId())) {
            return false;
        }
        if (other.usagePrice() == null ^ this.usagePrice() == null) {
            return false;
        }
        if (other.usagePrice() != null && !other.usagePrice().equals(this.usagePrice())) {
            return false;
        }
        if (other.currencyCodeString() == null ^ this.currencyCodeString() == null) {
            return false;
        }
        if (other.currencyCodeString() != null && !other.currencyCodeString().equals(this.currencyCodeString())) {
            return false;
        }
        if (other.instanceTenancyString() == null ^ this.instanceTenancyString() == null) {
            return false;
        }
        if (other.instanceTenancyString() != null && !other.instanceTenancyString().equals(this.instanceTenancyString())) {
            return false;
        }
        if (other.marketplace() == null ^ this.marketplace() == null) {
            return false;
        }
        if (other.marketplace() != null && !other.marketplace().equals(this.marketplace())) {
            return false;
        }
        if (other.offeringClassString() == null ^ this.offeringClassString() == null) {
            return false;
        }
        if (other.offeringClassString() != null && !other.offeringClassString().equals(this.offeringClassString())) {
            return false;
        }
        if (other.offeringTypeString() == null ^ this.offeringTypeString() == null) {
            return false;
        }
        if (other.offeringTypeString() != null && !other.offeringTypeString().equals(this.offeringTypeString())) {
            return false;
        }
        if (other.pricingDetails() == null ^ this.pricingDetails() == null) {
            return false;
        }
        if (other.pricingDetails() != null && !other.pricingDetails().equals(this.pricingDetails())) {
            return false;
        }
        if (other.recurringCharges() == null ^ this.recurringCharges() == null) {
            return false;
        }
        if (other.recurringCharges() != null && !other.recurringCharges().equals(this.recurringCharges())) {
            return false;
        }
        if (other.scopeString() == null ^ this.scopeString() == null) {
            return false;
        }
        return other.scopeString() == null || other.scopeString().equals(this.scopeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.duration() != null) {
            sb.append("Duration: ").append(this.duration()).append(",");
        }
        if (this.fixedPrice() != null) {
            sb.append("FixedPrice: ").append(this.fixedPrice()).append(",");
        }
        if (this.instanceTypeString() != null) {
            sb.append("InstanceType: ").append(this.instanceTypeString()).append(",");
        }
        if (this.productDescriptionString() != null) {
            sb.append("ProductDescription: ").append(this.productDescriptionString()).append(",");
        }
        if (this.reservedInstancesOfferingId() != null) {
            sb.append("ReservedInstancesOfferingId: ").append(this.reservedInstancesOfferingId()).append(",");
        }
        if (this.usagePrice() != null) {
            sb.append("UsagePrice: ").append(this.usagePrice()).append(",");
        }
        if (this.currencyCodeString() != null) {
            sb.append("CurrencyCode: ").append(this.currencyCodeString()).append(",");
        }
        if (this.instanceTenancyString() != null) {
            sb.append("InstanceTenancy: ").append(this.instanceTenancyString()).append(",");
        }
        if (this.marketplace() != null) {
            sb.append("Marketplace: ").append(this.marketplace()).append(",");
        }
        if (this.offeringClassString() != null) {
            sb.append("OfferingClass: ").append(this.offeringClassString()).append(",");
        }
        if (this.offeringTypeString() != null) {
            sb.append("OfferingType: ").append(this.offeringTypeString()).append(",");
        }
        if (this.pricingDetails() != null) {
            sb.append("PricingDetails: ").append(this.pricingDetails()).append(",");
        }
        if (this.recurringCharges() != null) {
            sb.append("RecurringCharges: ").append(this.recurringCharges()).append(",");
        }
        if (this.scopeString() != null) {
            sb.append("Scope: ").append(this.scopeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "Duration": {
                return Optional.of(clazz.cast(this.duration()));
            }
            case "FixedPrice": {
                return Optional.of(clazz.cast(this.fixedPrice()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceTypeString()));
            }
            case "ProductDescription": {
                return Optional.of(clazz.cast(this.productDescriptionString()));
            }
            case "ReservedInstancesOfferingId": {
                return Optional.of(clazz.cast(this.reservedInstancesOfferingId()));
            }
            case "UsagePrice": {
                return Optional.of(clazz.cast(this.usagePrice()));
            }
            case "CurrencyCode": {
                return Optional.of(clazz.cast(this.currencyCodeString()));
            }
            case "InstanceTenancy": {
                return Optional.of(clazz.cast(this.instanceTenancyString()));
            }
            case "Marketplace": {
                return Optional.of(clazz.cast(this.marketplace()));
            }
            case "OfferingClass": {
                return Optional.of(clazz.cast(this.offeringClassString()));
            }
            case "OfferingType": {
                return Optional.of(clazz.cast(this.offeringTypeString()));
            }
            case "PricingDetails": {
                return Optional.of(clazz.cast(this.pricingDetails()));
            }
            case "RecurringCharges": {
                return Optional.of(clazz.cast(this.recurringCharges()));
            }
            case "Scope": {
                return Optional.of(clazz.cast(this.scopeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private Long duration;
        private Float fixedPrice;
        private String instanceType;
        private String productDescription;
        private String reservedInstancesOfferingId;
        private Float usagePrice;
        private String currencyCode;
        private String instanceTenancy;
        private Boolean marketplace;
        private String offeringClass;
        private String offeringType;
        private List<PricingDetail> pricingDetails;
        private List<RecurringCharge> recurringCharges;
        private String scope;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesOffering model) {
            this.availabilityZone(model.availabilityZone);
            this.duration(model.duration);
            this.fixedPrice(model.fixedPrice);
            this.instanceType(model.instanceType);
            this.productDescription(model.productDescription);
            this.reservedInstancesOfferingId(model.reservedInstancesOfferingId);
            this.usagePrice(model.usagePrice);
            this.currencyCode(model.currencyCode);
            this.instanceTenancy(model.instanceTenancy);
            this.marketplace(model.marketplace);
            this.offeringClass(model.offeringClass);
            this.offeringType(model.offeringType);
            this.pricingDetails(model.pricingDetails);
            this.recurringCharges(model.recurringCharges);
            this.scope(model.scope);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Long getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        public final Float getFixedPrice() {
            return this.fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final void setFixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        @Override
        public final Builder productDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription.toString());
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final String getReservedInstancesOfferingId() {
            return this.reservedInstancesOfferingId;
        }

        @Override
        public final Builder reservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
            return this;
        }

        public final void setReservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
        }

        public final Float getUsagePrice() {
            return this.usagePrice;
        }

        @Override
        public final Builder usagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final void setUsagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final String getInstanceTenancy() {
            return this.instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        public final Boolean getMarketplace() {
            return this.marketplace;
        }

        @Override
        public final Builder marketplace(Boolean marketplace) {
            this.marketplace = marketplace;
            return this;
        }

        public final void setMarketplace(Boolean marketplace) {
            this.marketplace = marketplace;
        }

        public final String getOfferingClass() {
            return this.offeringClass;
        }

        @Override
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        public final Builder offeringClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass.toString());
            return this;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType.toString());
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public final Collection<PricingDetail.Builder> getPricingDetails() {
            return this.pricingDetails != null ? (Collection)this.pricingDetails.stream().map(PricingDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pricingDetails(Collection<PricingDetail> pricingDetails) {
            this.pricingDetails = PricingDetailsListCopier.copy(pricingDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pricingDetails(PricingDetail ... pricingDetails) {
            this.pricingDetails(Arrays.asList(pricingDetails));
            return this;
        }

        public final void setPricingDetails(Collection<PricingDetail.BuilderImpl> pricingDetails) {
            this.pricingDetails = PricingDetailsListCopier.copyFromBuilder(pricingDetails);
        }

        public final Collection<RecurringCharge.Builder> getRecurringCharges() {
            return this.recurringCharges != null ? (Collection)this.recurringCharges.stream().map(RecurringCharge::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge ... recurringCharges) {
            this.recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copyFromBuilder(recurringCharges);
        }

        public final String getScope() {
            return this.scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope.toString());
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        public ReservedInstancesOffering build() {
            return new ReservedInstancesOffering(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReservedInstancesOffering> {
        public Builder availabilityZone(String var1);

        public Builder duration(Long var1);

        public Builder fixedPrice(Float var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder productDescription(String var1);

        public Builder productDescription(RIProductDescription var1);

        public Builder reservedInstancesOfferingId(String var1);

        public Builder usagePrice(Float var1);

        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);

        public Builder instanceTenancy(String var1);

        public Builder instanceTenancy(Tenancy var1);

        public Builder marketplace(Boolean var1);

        public Builder offeringClass(String var1);

        public Builder offeringClass(OfferingClassType var1);

        public Builder offeringType(String var1);

        public Builder offeringType(OfferingTypeValues var1);

        public Builder pricingDetails(Collection<PricingDetail> var1);

        public Builder pricingDetails(PricingDetail ... var1);

        public Builder recurringCharges(Collection<RecurringCharge> var1);

        public Builder recurringCharges(RecurringCharge ... var1);

        public Builder scope(String var1);

        public Builder scope(Scope var1);
    }
}

