/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.ReservedInstanceLimitPrice;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PurchaseReservedInstancesOfferingRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PurchaseReservedInstancesOfferingRequest> {
    private final Integer instanceCount;
    private final String reservedInstancesOfferingId;
    private final ReservedInstanceLimitPrice limitPrice;

    private PurchaseReservedInstancesOfferingRequest(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.reservedInstancesOfferingId = builder.reservedInstancesOfferingId;
        this.limitPrice = builder.limitPrice;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public String reservedInstancesOfferingId() {
        return this.reservedInstancesOfferingId;
    }

    public ReservedInstanceLimitPrice limitPrice() {
        return this.limitPrice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceCount() == null ? 0 : this.instanceCount().hashCode());
        hashCode = 31 * hashCode + (this.reservedInstancesOfferingId() == null ? 0 : this.reservedInstancesOfferingId().hashCode());
        hashCode = 31 * hashCode + (this.limitPrice() == null ? 0 : this.limitPrice().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedInstancesOfferingRequest)) {
            return false;
        }
        PurchaseReservedInstancesOfferingRequest other = (PurchaseReservedInstancesOfferingRequest)((Object)obj);
        if (other.instanceCount() == null ^ this.instanceCount() == null) {
            return false;
        }
        if (other.instanceCount() != null && !other.instanceCount().equals(this.instanceCount())) {
            return false;
        }
        if (other.reservedInstancesOfferingId() == null ^ this.reservedInstancesOfferingId() == null) {
            return false;
        }
        if (other.reservedInstancesOfferingId() != null && !other.reservedInstancesOfferingId().equals(this.reservedInstancesOfferingId())) {
            return false;
        }
        if (other.limitPrice() == null ^ this.limitPrice() == null) {
            return false;
        }
        return other.limitPrice() == null || other.limitPrice().equals(this.limitPrice());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceCount() != null) {
            sb.append("InstanceCount: ").append(this.instanceCount()).append(",");
        }
        if (this.reservedInstancesOfferingId() != null) {
            sb.append("ReservedInstancesOfferingId: ").append(this.reservedInstancesOfferingId()).append(",");
        }
        if (this.limitPrice() != null) {
            sb.append("LimitPrice: ").append(this.limitPrice()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceCount": {
                return Optional.of(clazz.cast(this.instanceCount()));
            }
            case "ReservedInstancesOfferingId": {
                return Optional.of(clazz.cast(this.reservedInstancesOfferingId()));
            }
            case "LimitPrice": {
                return Optional.of(clazz.cast(this.limitPrice()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer instanceCount;
        private String reservedInstancesOfferingId;
        private ReservedInstanceLimitPrice limitPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedInstancesOfferingRequest model) {
            this.instanceCount(model.instanceCount);
            this.reservedInstancesOfferingId(model.reservedInstancesOfferingId);
            this.limitPrice(model.limitPrice);
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getReservedInstancesOfferingId() {
            return this.reservedInstancesOfferingId;
        }

        @Override
        public final Builder reservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
            return this;
        }

        public final void setReservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
        }

        public final ReservedInstanceLimitPrice.Builder getLimitPrice() {
            return this.limitPrice != null ? this.limitPrice.toBuilder() : null;
        }

        @Override
        public final Builder limitPrice(ReservedInstanceLimitPrice limitPrice) {
            this.limitPrice = limitPrice;
            return this;
        }

        public final void setLimitPrice(ReservedInstanceLimitPrice.BuilderImpl limitPrice) {
            this.limitPrice = limitPrice != null ? limitPrice.build() : null;
        }

        public PurchaseReservedInstancesOfferingRequest build() {
            return new PurchaseReservedInstancesOfferingRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PurchaseReservedInstancesOfferingRequest> {
        public Builder instanceCount(Integer var1);

        public Builder reservedInstancesOfferingId(String var1);

        public Builder limitPrice(ReservedInstanceLimitPrice var1);
    }
}

