/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyIdentityIdFormatRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyIdentityIdFormatRequest> {
    private final String principalArn;
    private final String resource;
    private final Boolean useLongIds;

    private ModifyIdentityIdFormatRequest(BuilderImpl builder) {
        this.principalArn = builder.principalArn;
        this.resource = builder.resource;
        this.useLongIds = builder.useLongIds;
    }

    public String principalArn() {
        return this.principalArn;
    }

    public String resource() {
        return this.resource;
    }

    public Boolean useLongIds() {
        return this.useLongIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.principalArn() == null ? 0 : this.principalArn().hashCode());
        hashCode = 31 * hashCode + (this.resource() == null ? 0 : this.resource().hashCode());
        hashCode = 31 * hashCode + (this.useLongIds() == null ? 0 : this.useLongIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIdentityIdFormatRequest)) {
            return false;
        }
        ModifyIdentityIdFormatRequest other = (ModifyIdentityIdFormatRequest)((Object)obj);
        if (other.principalArn() == null ^ this.principalArn() == null) {
            return false;
        }
        if (other.principalArn() != null && !other.principalArn().equals(this.principalArn())) {
            return false;
        }
        if (other.resource() == null ^ this.resource() == null) {
            return false;
        }
        if (other.resource() != null && !other.resource().equals(this.resource())) {
            return false;
        }
        if (other.useLongIds() == null ^ this.useLongIds() == null) {
            return false;
        }
        return other.useLongIds() == null || other.useLongIds().equals(this.useLongIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.principalArn() != null) {
            sb.append("PrincipalArn: ").append(this.principalArn()).append(",");
        }
        if (this.resource() != null) {
            sb.append("Resource: ").append(this.resource()).append(",");
        }
        if (this.useLongIds() != null) {
            sb.append("UseLongIds: ").append(this.useLongIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrincipalArn": {
                return Optional.of(clazz.cast(this.principalArn()));
            }
            case "Resource": {
                return Optional.of(clazz.cast(this.resource()));
            }
            case "UseLongIds": {
                return Optional.of(clazz.cast(this.useLongIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String principalArn;
        private String resource;
        private Boolean useLongIds;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIdentityIdFormatRequest model) {
            this.principalArn(model.principalArn);
            this.resource(model.resource);
            this.useLongIds(model.useLongIds);
        }

        public final String getPrincipalArn() {
            return this.principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        public final String getResource() {
            return this.resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        public final Boolean getUseLongIds() {
            return this.useLongIds;
        }

        @Override
        public final Builder useLongIds(Boolean useLongIds) {
            this.useLongIds = useLongIds;
            return this;
        }

        public final void setUseLongIds(Boolean useLongIds) {
            this.useLongIds = useLongIds;
        }

        public ModifyIdentityIdFormatRequest build() {
            return new ModifyIdentityIdFormatRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyIdentityIdFormatRequest> {
        public Builder principalArn(String var1);

        public Builder resource(String var1);

        public Builder useLongIds(Boolean var1);
    }
}

