/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.ArchitectureValues;
import software.amazon.awssdk.services.ec2.model.DeviceType;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifierListCopier;
import software.amazon.awssdk.services.ec2.model.HypervisorType;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfile;
import software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMappingListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceLifecycleType;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterface;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceState;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.Monitoring;
import software.amazon.awssdk.services.ec2.model.Placement;
import software.amazon.awssdk.services.ec2.model.PlatformValues;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.model.ProductCodeListCopier;
import software.amazon.awssdk.services.ec2.model.StateReason;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.VirtualizationType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Instance
implements ToCopyableBuilder<Builder, Instance> {
    private final Integer amiLaunchIndex;
    private final String imageId;
    private final String instanceId;
    private final String instanceType;
    private final String kernelId;
    private final String keyName;
    private final Instant launchTime;
    private final Monitoring monitoring;
    private final Placement placement;
    private final String platform;
    private final String privateDnsName;
    private final String privateIpAddress;
    private final List<ProductCode> productCodes;
    private final String publicDnsName;
    private final String publicIpAddress;
    private final String ramdiskId;
    private final InstanceState state;
    private final String stateTransitionReason;
    private final String subnetId;
    private final String vpcId;
    private final String architecture;
    private final List<InstanceBlockDeviceMapping> blockDeviceMappings;
    private final String clientToken;
    private final Boolean ebsOptimized;
    private final Boolean enaSupport;
    private final String hypervisor;
    private final IamInstanceProfile iamInstanceProfile;
    private final String instanceLifecycle;
    private final List<InstanceNetworkInterface> networkInterfaces;
    private final String rootDeviceName;
    private final String rootDeviceType;
    private final List<GroupIdentifier> securityGroups;
    private final Boolean sourceDestCheck;
    private final String spotInstanceRequestId;
    private final String sriovNetSupport;
    private final StateReason stateReason;
    private final List<Tag> tags;
    private final String virtualizationType;

    private Instance(BuilderImpl builder) {
        this.amiLaunchIndex = builder.amiLaunchIndex;
        this.imageId = builder.imageId;
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.launchTime = builder.launchTime;
        this.monitoring = builder.monitoring;
        this.placement = builder.placement;
        this.platform = builder.platform;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
        this.productCodes = builder.productCodes;
        this.publicDnsName = builder.publicDnsName;
        this.publicIpAddress = builder.publicIpAddress;
        this.ramdiskId = builder.ramdiskId;
        this.state = builder.state;
        this.stateTransitionReason = builder.stateTransitionReason;
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
        this.architecture = builder.architecture;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.clientToken = builder.clientToken;
        this.ebsOptimized = builder.ebsOptimized;
        this.enaSupport = builder.enaSupport;
        this.hypervisor = builder.hypervisor;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.instanceLifecycle = builder.instanceLifecycle;
        this.networkInterfaces = builder.networkInterfaces;
        this.rootDeviceName = builder.rootDeviceName;
        this.rootDeviceType = builder.rootDeviceType;
        this.securityGroups = builder.securityGroups;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.spotInstanceRequestId = builder.spotInstanceRequestId;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.stateReason = builder.stateReason;
        this.tags = builder.tags;
        this.virtualizationType = builder.virtualizationType;
    }

    public Integer amiLaunchIndex() {
        return this.amiLaunchIndex;
    }

    public String imageId() {
        return this.imageId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeString() {
        return this.instanceType;
    }

    public String kernelId() {
        return this.kernelId;
    }

    public String keyName() {
        return this.keyName;
    }

    public Instant launchTime() {
        return this.launchTime;
    }

    public Monitoring monitoring() {
        return this.monitoring;
    }

    public Placement placement() {
        return this.placement;
    }

    public PlatformValues platform() {
        return PlatformValues.fromValue(this.platform);
    }

    public String platformString() {
        return this.platform;
    }

    public String privateDnsName() {
        return this.privateDnsName;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public List<ProductCode> productCodes() {
        return this.productCodes;
    }

    public String publicDnsName() {
        return this.publicDnsName;
    }

    public String publicIpAddress() {
        return this.publicIpAddress;
    }

    public String ramdiskId() {
        return this.ramdiskId;
    }

    public InstanceState state() {
        return this.state;
    }

    public String stateTransitionReason() {
        return this.stateTransitionReason;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public ArchitectureValues architecture() {
        return ArchitectureValues.fromValue(this.architecture);
    }

    public String architectureString() {
        return this.architecture;
    }

    public List<InstanceBlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public Boolean enaSupport() {
        return this.enaSupport;
    }

    public HypervisorType hypervisor() {
        return HypervisorType.fromValue(this.hypervisor);
    }

    public String hypervisorString() {
        return this.hypervisor;
    }

    public IamInstanceProfile iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public InstanceLifecycleType instanceLifecycle() {
        return InstanceLifecycleType.fromValue(this.instanceLifecycle);
    }

    public String instanceLifecycleString() {
        return this.instanceLifecycle;
    }

    public List<InstanceNetworkInterface> networkInterfaces() {
        return this.networkInterfaces;
    }

    public String rootDeviceName() {
        return this.rootDeviceName;
    }

    public DeviceType rootDeviceType() {
        return DeviceType.fromValue(this.rootDeviceType);
    }

    public String rootDeviceTypeString() {
        return this.rootDeviceType;
    }

    public List<GroupIdentifier> securityGroups() {
        return this.securityGroups;
    }

    public Boolean sourceDestCheck() {
        return this.sourceDestCheck;
    }

    public String spotInstanceRequestId() {
        return this.spotInstanceRequestId;
    }

    public String sriovNetSupport() {
        return this.sriovNetSupport;
    }

    public StateReason stateReason() {
        return this.stateReason;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public VirtualizationType virtualizationType() {
        return VirtualizationType.fromValue(this.virtualizationType);
    }

    public String virtualizationTypeString() {
        return this.virtualizationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.amiLaunchIndex() == null ? 0 : this.amiLaunchIndex().hashCode());
        hashCode = 31 * hashCode + (this.imageId() == null ? 0 : this.imageId().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.instanceTypeString() == null ? 0 : this.instanceTypeString().hashCode());
        hashCode = 31 * hashCode + (this.kernelId() == null ? 0 : this.kernelId().hashCode());
        hashCode = 31 * hashCode + (this.keyName() == null ? 0 : this.keyName().hashCode());
        hashCode = 31 * hashCode + (this.launchTime() == null ? 0 : this.launchTime().hashCode());
        hashCode = 31 * hashCode + (this.monitoring() == null ? 0 : this.monitoring().hashCode());
        hashCode = 31 * hashCode + (this.placement() == null ? 0 : this.placement().hashCode());
        hashCode = 31 * hashCode + (this.platformString() == null ? 0 : this.platformString().hashCode());
        hashCode = 31 * hashCode + (this.privateDnsName() == null ? 0 : this.privateDnsName().hashCode());
        hashCode = 31 * hashCode + (this.privateIpAddress() == null ? 0 : this.privateIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.productCodes() == null ? 0 : this.productCodes().hashCode());
        hashCode = 31 * hashCode + (this.publicDnsName() == null ? 0 : this.publicDnsName().hashCode());
        hashCode = 31 * hashCode + (this.publicIpAddress() == null ? 0 : this.publicIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.ramdiskId() == null ? 0 : this.ramdiskId().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.stateTransitionReason() == null ? 0 : this.stateTransitionReason().hashCode());
        hashCode = 31 * hashCode + (this.subnetId() == null ? 0 : this.subnetId().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        hashCode = 31 * hashCode + (this.architectureString() == null ? 0 : this.architectureString().hashCode());
        hashCode = 31 * hashCode + (this.blockDeviceMappings() == null ? 0 : this.blockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.clientToken() == null ? 0 : this.clientToken().hashCode());
        hashCode = 31 * hashCode + (this.ebsOptimized() == null ? 0 : this.ebsOptimized().hashCode());
        hashCode = 31 * hashCode + (this.enaSupport() == null ? 0 : this.enaSupport().hashCode());
        hashCode = 31 * hashCode + (this.hypervisorString() == null ? 0 : this.hypervisorString().hashCode());
        hashCode = 31 * hashCode + (this.iamInstanceProfile() == null ? 0 : this.iamInstanceProfile().hashCode());
        hashCode = 31 * hashCode + (this.instanceLifecycleString() == null ? 0 : this.instanceLifecycleString().hashCode());
        hashCode = 31 * hashCode + (this.networkInterfaces() == null ? 0 : this.networkInterfaces().hashCode());
        hashCode = 31 * hashCode + (this.rootDeviceName() == null ? 0 : this.rootDeviceName().hashCode());
        hashCode = 31 * hashCode + (this.rootDeviceTypeString() == null ? 0 : this.rootDeviceTypeString().hashCode());
        hashCode = 31 * hashCode + (this.securityGroups() == null ? 0 : this.securityGroups().hashCode());
        hashCode = 31 * hashCode + (this.sourceDestCheck() == null ? 0 : this.sourceDestCheck().hashCode());
        hashCode = 31 * hashCode + (this.spotInstanceRequestId() == null ? 0 : this.spotInstanceRequestId().hashCode());
        hashCode = 31 * hashCode + (this.sriovNetSupport() == null ? 0 : this.sriovNetSupport().hashCode());
        hashCode = 31 * hashCode + (this.stateReason() == null ? 0 : this.stateReason().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.virtualizationTypeString() == null ? 0 : this.virtualizationTypeString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)obj;
        if (other.amiLaunchIndex() == null ^ this.amiLaunchIndex() == null) {
            return false;
        }
        if (other.amiLaunchIndex() != null && !other.amiLaunchIndex().equals(this.amiLaunchIndex())) {
            return false;
        }
        if (other.imageId() == null ^ this.imageId() == null) {
            return false;
        }
        if (other.imageId() != null && !other.imageId().equals(this.imageId())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.instanceTypeString() == null ^ this.instanceTypeString() == null) {
            return false;
        }
        if (other.instanceTypeString() != null && !other.instanceTypeString().equals(this.instanceTypeString())) {
            return false;
        }
        if (other.kernelId() == null ^ this.kernelId() == null) {
            return false;
        }
        if (other.kernelId() != null && !other.kernelId().equals(this.kernelId())) {
            return false;
        }
        if (other.keyName() == null ^ this.keyName() == null) {
            return false;
        }
        if (other.keyName() != null && !other.keyName().equals(this.keyName())) {
            return false;
        }
        if (other.launchTime() == null ^ this.launchTime() == null) {
            return false;
        }
        if (other.launchTime() != null && !other.launchTime().equals(this.launchTime())) {
            return false;
        }
        if (other.monitoring() == null ^ this.monitoring() == null) {
            return false;
        }
        if (other.monitoring() != null && !other.monitoring().equals(this.monitoring())) {
            return false;
        }
        if (other.placement() == null ^ this.placement() == null) {
            return false;
        }
        if (other.placement() != null && !other.placement().equals(this.placement())) {
            return false;
        }
        if (other.platformString() == null ^ this.platformString() == null) {
            return false;
        }
        if (other.platformString() != null && !other.platformString().equals(this.platformString())) {
            return false;
        }
        if (other.privateDnsName() == null ^ this.privateDnsName() == null) {
            return false;
        }
        if (other.privateDnsName() != null && !other.privateDnsName().equals(this.privateDnsName())) {
            return false;
        }
        if (other.privateIpAddress() == null ^ this.privateIpAddress() == null) {
            return false;
        }
        if (other.privateIpAddress() != null && !other.privateIpAddress().equals(this.privateIpAddress())) {
            return false;
        }
        if (other.productCodes() == null ^ this.productCodes() == null) {
            return false;
        }
        if (other.productCodes() != null && !other.productCodes().equals(this.productCodes())) {
            return false;
        }
        if (other.publicDnsName() == null ^ this.publicDnsName() == null) {
            return false;
        }
        if (other.publicDnsName() != null && !other.publicDnsName().equals(this.publicDnsName())) {
            return false;
        }
        if (other.publicIpAddress() == null ^ this.publicIpAddress() == null) {
            return false;
        }
        if (other.publicIpAddress() != null && !other.publicIpAddress().equals(this.publicIpAddress())) {
            return false;
        }
        if (other.ramdiskId() == null ^ this.ramdiskId() == null) {
            return false;
        }
        if (other.ramdiskId() != null && !other.ramdiskId().equals(this.ramdiskId())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.stateTransitionReason() == null ^ this.stateTransitionReason() == null) {
            return false;
        }
        if (other.stateTransitionReason() != null && !other.stateTransitionReason().equals(this.stateTransitionReason())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.architectureString() == null ^ this.architectureString() == null) {
            return false;
        }
        if (other.architectureString() != null && !other.architectureString().equals(this.architectureString())) {
            return false;
        }
        if (other.blockDeviceMappings() == null ^ this.blockDeviceMappings() == null) {
            return false;
        }
        if (other.blockDeviceMappings() != null && !other.blockDeviceMappings().equals(this.blockDeviceMappings())) {
            return false;
        }
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.ebsOptimized() == null ^ this.ebsOptimized() == null) {
            return false;
        }
        if (other.ebsOptimized() != null && !other.ebsOptimized().equals(this.ebsOptimized())) {
            return false;
        }
        if (other.enaSupport() == null ^ this.enaSupport() == null) {
            return false;
        }
        if (other.enaSupport() != null && !other.enaSupport().equals(this.enaSupport())) {
            return false;
        }
        if (other.hypervisorString() == null ^ this.hypervisorString() == null) {
            return false;
        }
        if (other.hypervisorString() != null && !other.hypervisorString().equals(this.hypervisorString())) {
            return false;
        }
        if (other.iamInstanceProfile() == null ^ this.iamInstanceProfile() == null) {
            return false;
        }
        if (other.iamInstanceProfile() != null && !other.iamInstanceProfile().equals(this.iamInstanceProfile())) {
            return false;
        }
        if (other.instanceLifecycleString() == null ^ this.instanceLifecycleString() == null) {
            return false;
        }
        if (other.instanceLifecycleString() != null && !other.instanceLifecycleString().equals(this.instanceLifecycleString())) {
            return false;
        }
        if (other.networkInterfaces() == null ^ this.networkInterfaces() == null) {
            return false;
        }
        if (other.networkInterfaces() != null && !other.networkInterfaces().equals(this.networkInterfaces())) {
            return false;
        }
        if (other.rootDeviceName() == null ^ this.rootDeviceName() == null) {
            return false;
        }
        if (other.rootDeviceName() != null && !other.rootDeviceName().equals(this.rootDeviceName())) {
            return false;
        }
        if (other.rootDeviceTypeString() == null ^ this.rootDeviceTypeString() == null) {
            return false;
        }
        if (other.rootDeviceTypeString() != null && !other.rootDeviceTypeString().equals(this.rootDeviceTypeString())) {
            return false;
        }
        if (other.securityGroups() == null ^ this.securityGroups() == null) {
            return false;
        }
        if (other.securityGroups() != null && !other.securityGroups().equals(this.securityGroups())) {
            return false;
        }
        if (other.sourceDestCheck() == null ^ this.sourceDestCheck() == null) {
            return false;
        }
        if (other.sourceDestCheck() != null && !other.sourceDestCheck().equals(this.sourceDestCheck())) {
            return false;
        }
        if (other.spotInstanceRequestId() == null ^ this.spotInstanceRequestId() == null) {
            return false;
        }
        if (other.spotInstanceRequestId() != null && !other.spotInstanceRequestId().equals(this.spotInstanceRequestId())) {
            return false;
        }
        if (other.sriovNetSupport() == null ^ this.sriovNetSupport() == null) {
            return false;
        }
        if (other.sriovNetSupport() != null && !other.sriovNetSupport().equals(this.sriovNetSupport())) {
            return false;
        }
        if (other.stateReason() == null ^ this.stateReason() == null) {
            return false;
        }
        if (other.stateReason() != null && !other.stateReason().equals(this.stateReason())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.virtualizationTypeString() == null ^ this.virtualizationTypeString() == null) {
            return false;
        }
        return other.virtualizationTypeString() == null || other.virtualizationTypeString().equals(this.virtualizationTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.amiLaunchIndex() != null) {
            sb.append("AmiLaunchIndex: ").append(this.amiLaunchIndex()).append(",");
        }
        if (this.imageId() != null) {
            sb.append("ImageId: ").append(this.imageId()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.instanceTypeString() != null) {
            sb.append("InstanceType: ").append(this.instanceTypeString()).append(",");
        }
        if (this.kernelId() != null) {
            sb.append("KernelId: ").append(this.kernelId()).append(",");
        }
        if (this.keyName() != null) {
            sb.append("KeyName: ").append(this.keyName()).append(",");
        }
        if (this.launchTime() != null) {
            sb.append("LaunchTime: ").append(this.launchTime()).append(",");
        }
        if (this.monitoring() != null) {
            sb.append("Monitoring: ").append(this.monitoring()).append(",");
        }
        if (this.placement() != null) {
            sb.append("Placement: ").append(this.placement()).append(",");
        }
        if (this.platformString() != null) {
            sb.append("Platform: ").append(this.platformString()).append(",");
        }
        if (this.privateDnsName() != null) {
            sb.append("PrivateDnsName: ").append(this.privateDnsName()).append(",");
        }
        if (this.privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(this.privateIpAddress()).append(",");
        }
        if (this.productCodes() != null) {
            sb.append("ProductCodes: ").append(this.productCodes()).append(",");
        }
        if (this.publicDnsName() != null) {
            sb.append("PublicDnsName: ").append(this.publicDnsName()).append(",");
        }
        if (this.publicIpAddress() != null) {
            sb.append("PublicIpAddress: ").append(this.publicIpAddress()).append(",");
        }
        if (this.ramdiskId() != null) {
            sb.append("RamdiskId: ").append(this.ramdiskId()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.stateTransitionReason() != null) {
            sb.append("StateTransitionReason: ").append(this.stateTransitionReason()).append(",");
        }
        if (this.subnetId() != null) {
            sb.append("SubnetId: ").append(this.subnetId()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (this.architectureString() != null) {
            sb.append("Architecture: ").append(this.architectureString()).append(",");
        }
        if (this.blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.blockDeviceMappings()).append(",");
        }
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.ebsOptimized()).append(",");
        }
        if (this.enaSupport() != null) {
            sb.append("EnaSupport: ").append(this.enaSupport()).append(",");
        }
        if (this.hypervisorString() != null) {
            sb.append("Hypervisor: ").append(this.hypervisorString()).append(",");
        }
        if (this.iamInstanceProfile() != null) {
            sb.append("IamInstanceProfile: ").append(this.iamInstanceProfile()).append(",");
        }
        if (this.instanceLifecycleString() != null) {
            sb.append("InstanceLifecycle: ").append(this.instanceLifecycleString()).append(",");
        }
        if (this.networkInterfaces() != null) {
            sb.append("NetworkInterfaces: ").append(this.networkInterfaces()).append(",");
        }
        if (this.rootDeviceName() != null) {
            sb.append("RootDeviceName: ").append(this.rootDeviceName()).append(",");
        }
        if (this.rootDeviceTypeString() != null) {
            sb.append("RootDeviceType: ").append(this.rootDeviceTypeString()).append(",");
        }
        if (this.securityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.securityGroups()).append(",");
        }
        if (this.sourceDestCheck() != null) {
            sb.append("SourceDestCheck: ").append(this.sourceDestCheck()).append(",");
        }
        if (this.spotInstanceRequestId() != null) {
            sb.append("SpotInstanceRequestId: ").append(this.spotInstanceRequestId()).append(",");
        }
        if (this.sriovNetSupport() != null) {
            sb.append("SriovNetSupport: ").append(this.sriovNetSupport()).append(",");
        }
        if (this.stateReason() != null) {
            sb.append("StateReason: ").append(this.stateReason()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.virtualizationTypeString() != null) {
            sb.append("VirtualizationType: ").append(this.virtualizationTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmiLaunchIndex": {
                return Optional.of(clazz.cast(this.amiLaunchIndex()));
            }
            case "ImageId": {
                return Optional.of(clazz.cast(this.imageId()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceTypeString()));
            }
            case "KernelId": {
                return Optional.of(clazz.cast(this.kernelId()));
            }
            case "KeyName": {
                return Optional.of(clazz.cast(this.keyName()));
            }
            case "LaunchTime": {
                return Optional.of(clazz.cast(this.launchTime()));
            }
            case "Monitoring": {
                return Optional.of(clazz.cast(this.monitoring()));
            }
            case "Placement": {
                return Optional.of(clazz.cast(this.placement()));
            }
            case "Platform": {
                return Optional.of(clazz.cast(this.platformString()));
            }
            case "PrivateDnsName": {
                return Optional.of(clazz.cast(this.privateDnsName()));
            }
            case "PrivateIpAddress": {
                return Optional.of(clazz.cast(this.privateIpAddress()));
            }
            case "ProductCodes": {
                return Optional.of(clazz.cast(this.productCodes()));
            }
            case "PublicDnsName": {
                return Optional.of(clazz.cast(this.publicDnsName()));
            }
            case "PublicIpAddress": {
                return Optional.of(clazz.cast(this.publicIpAddress()));
            }
            case "RamdiskId": {
                return Optional.of(clazz.cast(this.ramdiskId()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.state()));
            }
            case "StateTransitionReason": {
                return Optional.of(clazz.cast(this.stateTransitionReason()));
            }
            case "SubnetId": {
                return Optional.of(clazz.cast(this.subnetId()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
            case "Architecture": {
                return Optional.of(clazz.cast(this.architectureString()));
            }
            case "BlockDeviceMappings": {
                return Optional.of(clazz.cast(this.blockDeviceMappings()));
            }
            case "ClientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
            case "EbsOptimized": {
                return Optional.of(clazz.cast(this.ebsOptimized()));
            }
            case "EnaSupport": {
                return Optional.of(clazz.cast(this.enaSupport()));
            }
            case "Hypervisor": {
                return Optional.of(clazz.cast(this.hypervisorString()));
            }
            case "IamInstanceProfile": {
                return Optional.of(clazz.cast(this.iamInstanceProfile()));
            }
            case "InstanceLifecycle": {
                return Optional.of(clazz.cast(this.instanceLifecycleString()));
            }
            case "NetworkInterfaces": {
                return Optional.of(clazz.cast(this.networkInterfaces()));
            }
            case "RootDeviceName": {
                return Optional.of(clazz.cast(this.rootDeviceName()));
            }
            case "RootDeviceType": {
                return Optional.of(clazz.cast(this.rootDeviceTypeString()));
            }
            case "SecurityGroups": {
                return Optional.of(clazz.cast(this.securityGroups()));
            }
            case "SourceDestCheck": {
                return Optional.of(clazz.cast(this.sourceDestCheck()));
            }
            case "SpotInstanceRequestId": {
                return Optional.of(clazz.cast(this.spotInstanceRequestId()));
            }
            case "SriovNetSupport": {
                return Optional.of(clazz.cast(this.sriovNetSupport()));
            }
            case "StateReason": {
                return Optional.of(clazz.cast(this.stateReason()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "VirtualizationType": {
                return Optional.of(clazz.cast(this.virtualizationTypeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer amiLaunchIndex;
        private String imageId;
        private String instanceId;
        private String instanceType;
        private String kernelId;
        private String keyName;
        private Instant launchTime;
        private Monitoring monitoring;
        private Placement placement;
        private String platform;
        private String privateDnsName;
        private String privateIpAddress;
        private List<ProductCode> productCodes;
        private String publicDnsName;
        private String publicIpAddress;
        private String ramdiskId;
        private InstanceState state;
        private String stateTransitionReason;
        private String subnetId;
        private String vpcId;
        private String architecture;
        private List<InstanceBlockDeviceMapping> blockDeviceMappings;
        private String clientToken;
        private Boolean ebsOptimized;
        private Boolean enaSupport;
        private String hypervisor;
        private IamInstanceProfile iamInstanceProfile;
        private String instanceLifecycle;
        private List<InstanceNetworkInterface> networkInterfaces;
        private String rootDeviceName;
        private String rootDeviceType;
        private List<GroupIdentifier> securityGroups;
        private Boolean sourceDestCheck;
        private String spotInstanceRequestId;
        private String sriovNetSupport;
        private StateReason stateReason;
        private List<Tag> tags;
        private String virtualizationType;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            this.amiLaunchIndex(model.amiLaunchIndex);
            this.imageId(model.imageId);
            this.instanceId(model.instanceId);
            this.instanceType(model.instanceType);
            this.kernelId(model.kernelId);
            this.keyName(model.keyName);
            this.launchTime(model.launchTime);
            this.monitoring(model.monitoring);
            this.placement(model.placement);
            this.platform(model.platform);
            this.privateDnsName(model.privateDnsName);
            this.privateIpAddress(model.privateIpAddress);
            this.productCodes(model.productCodes);
            this.publicDnsName(model.publicDnsName);
            this.publicIpAddress(model.publicIpAddress);
            this.ramdiskId(model.ramdiskId);
            this.state(model.state);
            this.stateTransitionReason(model.stateTransitionReason);
            this.subnetId(model.subnetId);
            this.vpcId(model.vpcId);
            this.architecture(model.architecture);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.clientToken(model.clientToken);
            this.ebsOptimized(model.ebsOptimized);
            this.enaSupport(model.enaSupport);
            this.hypervisor(model.hypervisor);
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.instanceLifecycle(model.instanceLifecycle);
            this.networkInterfaces(model.networkInterfaces);
            this.rootDeviceName(model.rootDeviceName);
            this.rootDeviceType(model.rootDeviceType);
            this.securityGroups(model.securityGroups);
            this.sourceDestCheck(model.sourceDestCheck);
            this.spotInstanceRequestId(model.spotInstanceRequestId);
            this.sriovNetSupport(model.sriovNetSupport);
            this.stateReason(model.stateReason);
            this.tags(model.tags);
            this.virtualizationType(model.virtualizationType);
        }

        public final Integer getAmiLaunchIndex() {
            return this.amiLaunchIndex;
        }

        @Override
        public final Builder amiLaunchIndex(Integer amiLaunchIndex) {
            this.amiLaunchIndex = amiLaunchIndex;
            return this;
        }

        public final void setAmiLaunchIndex(Integer amiLaunchIndex) {
            this.amiLaunchIndex = amiLaunchIndex;
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final Instant getLaunchTime() {
            return this.launchTime;
        }

        @Override
        public final Builder launchTime(Instant launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        public final void setLaunchTime(Instant launchTime) {
            this.launchTime = launchTime;
        }

        public final Monitoring.Builder getMonitoring() {
            return this.monitoring != null ? this.monitoring.toBuilder() : null;
        }

        @Override
        public final Builder monitoring(Monitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(Monitoring.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        public final Placement.Builder getPlacement() {
            return this.placement != null ? this.placement.toBuilder() : null;
        }

        @Override
        public final Builder placement(Placement placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(Placement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformValues platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getPrivateDnsName() {
            return this.privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final Collection<ProductCode.Builder> getProductCodes() {
            return this.productCodes != null ? (Collection)this.productCodes.stream().map(ProductCode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        public final String getPublicDnsName() {
            return this.publicDnsName;
        }

        @Override
        public final Builder publicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
            return this;
        }

        public final void setPublicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
        }

        public final String getPublicIpAddress() {
            return this.publicIpAddress;
        }

        @Override
        public final Builder publicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
            return this;
        }

        public final void setPublicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final InstanceState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        @Override
        public final Builder state(InstanceState state) {
            this.state = state;
            return this;
        }

        public final void setState(InstanceState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        public final String getStateTransitionReason() {
            return this.stateTransitionReason;
        }

        @Override
        public final Builder stateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
            return this;
        }

        public final void setStateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(ArchitectureValues architecture) {
            this.architecture(architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final Collection<InstanceBlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return this.blockDeviceMappings != null ? (Collection)this.blockDeviceMappings.stream().map(InstanceBlockDeviceMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(InstanceBlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<InstanceBlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final Boolean getEnaSupport() {
            return this.enaSupport;
        }

        @Override
        public final Builder enaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final void setEnaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
        }

        public final String getHypervisor() {
            return this.hypervisor;
        }

        @Override
        public final Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        @Override
        public final Builder hypervisor(HypervisorType hypervisor) {
            this.hypervisor(hypervisor.toString());
            return this;
        }

        public final void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        public final IamInstanceProfile.Builder getIamInstanceProfile() {
            return this.iamInstanceProfile != null ? this.iamInstanceProfile.toBuilder() : null;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfile iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(IamInstanceProfile.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        public final String getInstanceLifecycle() {
            return this.instanceLifecycle;
        }

        @Override
        public final Builder instanceLifecycle(String instanceLifecycle) {
            this.instanceLifecycle = instanceLifecycle;
            return this;
        }

        @Override
        public final Builder instanceLifecycle(InstanceLifecycleType instanceLifecycle) {
            this.instanceLifecycle(instanceLifecycle.toString());
            return this;
        }

        public final void setInstanceLifecycle(String instanceLifecycle) {
            this.instanceLifecycle = instanceLifecycle;
        }

        public final Collection<InstanceNetworkInterface.Builder> getNetworkInterfaces() {
            return this.networkInterfaces != null ? (Collection)this.networkInterfaces.stream().map(InstanceNetworkInterface::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkInterfaces(Collection<InstanceNetworkInterface> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(InstanceNetworkInterface ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        public final void setNetworkInterfaces(Collection<InstanceNetworkInterface.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceListCopier.copyFromBuilder(networkInterfaces);
        }

        public final String getRootDeviceName() {
            return this.rootDeviceName;
        }

        @Override
        public final Builder rootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
            return this;
        }

        public final void setRootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
        }

        public final String getRootDeviceType() {
            return this.rootDeviceType;
        }

        @Override
        public final Builder rootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
            return this;
        }

        @Override
        public final Builder rootDeviceType(DeviceType rootDeviceType) {
            this.rootDeviceType(rootDeviceType.toString());
            return this;
        }

        public final void setRootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
        }

        public final Collection<GroupIdentifier.Builder> getSecurityGroups() {
            return this.securityGroups != null ? (Collection)this.securityGroups.stream().map(GroupIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder securityGroups(Collection<GroupIdentifier> securityGroups) {
            this.securityGroups = GroupIdentifierListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(GroupIdentifier ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<GroupIdentifier.BuilderImpl> securityGroups) {
            this.securityGroups = GroupIdentifierListCopier.copyFromBuilder(securityGroups);
        }

        public final Boolean getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        public final String getSpotInstanceRequestId() {
            return this.spotInstanceRequestId;
        }

        @Override
        public final Builder spotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
            return this;
        }

        public final void setSpotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
        }

        public final String getSriovNetSupport() {
            return this.sriovNetSupport;
        }

        @Override
        public final Builder sriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final void setSriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
        }

        public final StateReason.Builder getStateReason() {
            return this.stateReason != null ? this.stateReason.toBuilder() : null;
        }

        @Override
        public final Builder stateReason(StateReason stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final void setStateReason(StateReason.BuilderImpl stateReason) {
            this.stateReason = stateReason != null ? stateReason.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getVirtualizationType() {
            return this.virtualizationType;
        }

        @Override
        public final Builder virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        @Override
        public final Builder virtualizationType(VirtualizationType virtualizationType) {
            this.virtualizationType(virtualizationType.toString());
            return this;
        }

        public final void setVirtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
        }

        public Instance build() {
            return new Instance(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Instance> {
        public Builder amiLaunchIndex(Integer var1);

        public Builder imageId(String var1);

        public Builder instanceId(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder kernelId(String var1);

        public Builder keyName(String var1);

        public Builder launchTime(Instant var1);

        public Builder monitoring(Monitoring var1);

        public Builder placement(Placement var1);

        public Builder platform(String var1);

        public Builder platform(PlatformValues var1);

        public Builder privateDnsName(String var1);

        public Builder privateIpAddress(String var1);

        public Builder productCodes(Collection<ProductCode> var1);

        public Builder productCodes(ProductCode ... var1);

        public Builder publicDnsName(String var1);

        public Builder publicIpAddress(String var1);

        public Builder ramdiskId(String var1);

        public Builder state(InstanceState var1);

        public Builder stateTransitionReason(String var1);

        public Builder subnetId(String var1);

        public Builder vpcId(String var1);

        public Builder architecture(String var1);

        public Builder architecture(ArchitectureValues var1);

        public Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> var1);

        public Builder blockDeviceMappings(InstanceBlockDeviceMapping ... var1);

        public Builder clientToken(String var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder enaSupport(Boolean var1);

        public Builder hypervisor(String var1);

        public Builder hypervisor(HypervisorType var1);

        public Builder iamInstanceProfile(IamInstanceProfile var1);

        public Builder instanceLifecycle(String var1);

        public Builder instanceLifecycle(InstanceLifecycleType var1);

        public Builder networkInterfaces(Collection<InstanceNetworkInterface> var1);

        public Builder networkInterfaces(InstanceNetworkInterface ... var1);

        public Builder rootDeviceName(String var1);

        public Builder rootDeviceType(String var1);

        public Builder rootDeviceType(DeviceType var1);

        public Builder securityGroups(Collection<GroupIdentifier> var1);

        public Builder securityGroups(GroupIdentifier ... var1);

        public Builder sourceDestCheck(Boolean var1);

        public Builder spotInstanceRequestId(String var1);

        public Builder sriovNetSupport(String var1);

        public Builder stateReason(StateReason var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder virtualizationType(String var1);

        public Builder virtualizationType(VirtualizationType var1);
    }
}

