/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.UserBucket;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImageDiskContainer
implements ToCopyableBuilder<Builder, ImageDiskContainer> {
    private final String description;
    private final String deviceName;
    private final String format;
    private final String snapshotId;
    private final String url;
    private final UserBucket userBucket;

    private ImageDiskContainer(BuilderImpl builder) {
        this.description = builder.description;
        this.deviceName = builder.deviceName;
        this.format = builder.format;
        this.snapshotId = builder.snapshotId;
        this.url = builder.url;
        this.userBucket = builder.userBucket;
    }

    public String description() {
        return this.description;
    }

    public String deviceName() {
        return this.deviceName;
    }

    public String format() {
        return this.format;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public String url() {
        return this.url;
    }

    public UserBucket userBucket() {
        return this.userBucket;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.deviceName() == null ? 0 : this.deviceName().hashCode());
        hashCode = 31 * hashCode + (this.format() == null ? 0 : this.format().hashCode());
        hashCode = 31 * hashCode + (this.snapshotId() == null ? 0 : this.snapshotId().hashCode());
        hashCode = 31 * hashCode + (this.url() == null ? 0 : this.url().hashCode());
        hashCode = 31 * hashCode + (this.userBucket() == null ? 0 : this.userBucket().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageDiskContainer)) {
            return false;
        }
        ImageDiskContainer other = (ImageDiskContainer)obj;
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.deviceName() == null ^ this.deviceName() == null) {
            return false;
        }
        if (other.deviceName() != null && !other.deviceName().equals(this.deviceName())) {
            return false;
        }
        if (other.format() == null ^ this.format() == null) {
            return false;
        }
        if (other.format() != null && !other.format().equals(this.format())) {
            return false;
        }
        if (other.snapshotId() == null ^ this.snapshotId() == null) {
            return false;
        }
        if (other.snapshotId() != null && !other.snapshotId().equals(this.snapshotId())) {
            return false;
        }
        if (other.url() == null ^ this.url() == null) {
            return false;
        }
        if (other.url() != null && !other.url().equals(this.url())) {
            return false;
        }
        if (other.userBucket() == null ^ this.userBucket() == null) {
            return false;
        }
        return other.userBucket() == null || other.userBucket().equals(this.userBucket());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.deviceName() != null) {
            sb.append("DeviceName: ").append(this.deviceName()).append(",");
        }
        if (this.format() != null) {
            sb.append("Format: ").append(this.format()).append(",");
        }
        if (this.snapshotId() != null) {
            sb.append("SnapshotId: ").append(this.snapshotId()).append(",");
        }
        if (this.url() != null) {
            sb.append("Url: ").append(this.url()).append(",");
        }
        if (this.userBucket() != null) {
            sb.append("UserBucket: ").append(this.userBucket()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "DeviceName": {
                return Optional.of(clazz.cast(this.deviceName()));
            }
            case "Format": {
                return Optional.of(clazz.cast(this.format()));
            }
            case "SnapshotId": {
                return Optional.of(clazz.cast(this.snapshotId()));
            }
            case "Url": {
                return Optional.of(clazz.cast(this.url()));
            }
            case "UserBucket": {
                return Optional.of(clazz.cast(this.userBucket()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String deviceName;
        private String format;
        private String snapshotId;
        private String url;
        private UserBucket userBucket;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageDiskContainer model) {
            this.description(model.description);
            this.deviceName(model.deviceName);
            this.format(model.format);
            this.snapshotId(model.snapshotId);
            this.url(model.url);
            this.userBucket(model.userBucket);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final UserBucket.Builder getUserBucket() {
            return this.userBucket != null ? this.userBucket.toBuilder() : null;
        }

        @Override
        public final Builder userBucket(UserBucket userBucket) {
            this.userBucket = userBucket;
            return this;
        }

        public final void setUserBucket(UserBucket.BuilderImpl userBucket) {
            this.userBucket = userBucket != null ? userBucket.build() : null;
        }

        public ImageDiskContainer build() {
            return new ImageDiskContainer(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImageDiskContainer> {
        public Builder description(String var1);

        public Builder deviceName(String var1);

        public Builder format(String var1);

        public Builder snapshotId(String var1);

        public Builder url(String var1);

        public Builder userBucket(UserBucket var1);
    }
}

