/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.ContainerFormat;
import software.amazon.awssdk.services.ec2.model.DiskImageFormat;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ExportToS3Task
implements ToCopyableBuilder<Builder, ExportToS3Task> {
    private final String containerFormat;
    private final String diskImageFormat;
    private final String s3Bucket;
    private final String s3Key;

    private ExportToS3Task(BuilderImpl builder) {
        this.containerFormat = builder.containerFormat;
        this.diskImageFormat = builder.diskImageFormat;
        this.s3Bucket = builder.s3Bucket;
        this.s3Key = builder.s3Key;
    }

    public ContainerFormat containerFormat() {
        return ContainerFormat.fromValue(this.containerFormat);
    }

    public String containerFormatString() {
        return this.containerFormat;
    }

    public DiskImageFormat diskImageFormat() {
        return DiskImageFormat.fromValue(this.diskImageFormat);
    }

    public String diskImageFormatString() {
        return this.diskImageFormat;
    }

    public String s3Bucket() {
        return this.s3Bucket;
    }

    public String s3Key() {
        return this.s3Key;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.containerFormatString() == null ? 0 : this.containerFormatString().hashCode());
        hashCode = 31 * hashCode + (this.diskImageFormatString() == null ? 0 : this.diskImageFormatString().hashCode());
        hashCode = 31 * hashCode + (this.s3Bucket() == null ? 0 : this.s3Bucket().hashCode());
        hashCode = 31 * hashCode + (this.s3Key() == null ? 0 : this.s3Key().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportToS3Task)) {
            return false;
        }
        ExportToS3Task other = (ExportToS3Task)obj;
        if (other.containerFormatString() == null ^ this.containerFormatString() == null) {
            return false;
        }
        if (other.containerFormatString() != null && !other.containerFormatString().equals(this.containerFormatString())) {
            return false;
        }
        if (other.diskImageFormatString() == null ^ this.diskImageFormatString() == null) {
            return false;
        }
        if (other.diskImageFormatString() != null && !other.diskImageFormatString().equals(this.diskImageFormatString())) {
            return false;
        }
        if (other.s3Bucket() == null ^ this.s3Bucket() == null) {
            return false;
        }
        if (other.s3Bucket() != null && !other.s3Bucket().equals(this.s3Bucket())) {
            return false;
        }
        if (other.s3Key() == null ^ this.s3Key() == null) {
            return false;
        }
        return other.s3Key() == null || other.s3Key().equals(this.s3Key());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.containerFormatString() != null) {
            sb.append("ContainerFormat: ").append(this.containerFormatString()).append(",");
        }
        if (this.diskImageFormatString() != null) {
            sb.append("DiskImageFormat: ").append(this.diskImageFormatString()).append(",");
        }
        if (this.s3Bucket() != null) {
            sb.append("S3Bucket: ").append(this.s3Bucket()).append(",");
        }
        if (this.s3Key() != null) {
            sb.append("S3Key: ").append(this.s3Key()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerFormat": {
                return Optional.of(clazz.cast(this.containerFormatString()));
            }
            case "DiskImageFormat": {
                return Optional.of(clazz.cast(this.diskImageFormatString()));
            }
            case "S3Bucket": {
                return Optional.of(clazz.cast(this.s3Bucket()));
            }
            case "S3Key": {
                return Optional.of(clazz.cast(this.s3Key()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String containerFormat;
        private String diskImageFormat;
        private String s3Bucket;
        private String s3Key;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportToS3Task model) {
            this.containerFormat(model.containerFormat);
            this.diskImageFormat(model.diskImageFormat);
            this.s3Bucket(model.s3Bucket);
            this.s3Key(model.s3Key);
        }

        public final String getContainerFormat() {
            return this.containerFormat;
        }

        @Override
        public final Builder containerFormat(String containerFormat) {
            this.containerFormat = containerFormat;
            return this;
        }

        @Override
        public final Builder containerFormat(ContainerFormat containerFormat) {
            this.containerFormat(containerFormat.toString());
            return this;
        }

        public final void setContainerFormat(String containerFormat) {
            this.containerFormat = containerFormat;
        }

        public final String getDiskImageFormat() {
            return this.diskImageFormat;
        }

        @Override
        public final Builder diskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
            return this;
        }

        @Override
        public final Builder diskImageFormat(DiskImageFormat diskImageFormat) {
            this.diskImageFormat(diskImageFormat.toString());
            return this;
        }

        public final void setDiskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3Key() {
            return this.s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        public ExportToS3Task build() {
            return new ExportToS3Task(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ExportToS3Task> {
        public Builder containerFormat(String var1);

        public Builder containerFormat(ContainerFormat var1);

        public Builder diskImageFormat(String var1);

        public Builder diskImageFormat(DiskImageFormat var1);

        public Builder s3Bucket(String var1);

        public Builder s3Key(String var1);
    }
}

