/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.DiskImageFormat;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DiskImageDescription
implements ToCopyableBuilder<Builder, DiskImageDescription> {
    private final String checksum;
    private final String format;
    private final String importManifestUrl;
    private final Long size;

    private DiskImageDescription(BuilderImpl builder) {
        this.checksum = builder.checksum;
        this.format = builder.format;
        this.importManifestUrl = builder.importManifestUrl;
        this.size = builder.size;
    }

    public String checksum() {
        return this.checksum;
    }

    public DiskImageFormat format() {
        return DiskImageFormat.fromValue(this.format);
    }

    public String formatString() {
        return this.format;
    }

    public String importManifestUrl() {
        return this.importManifestUrl;
    }

    public Long size() {
        return this.size;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.checksum() == null ? 0 : this.checksum().hashCode());
        hashCode = 31 * hashCode + (this.formatString() == null ? 0 : this.formatString().hashCode());
        hashCode = 31 * hashCode + (this.importManifestUrl() == null ? 0 : this.importManifestUrl().hashCode());
        hashCode = 31 * hashCode + (this.size() == null ? 0 : this.size().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiskImageDescription)) {
            return false;
        }
        DiskImageDescription other = (DiskImageDescription)obj;
        if (other.checksum() == null ^ this.checksum() == null) {
            return false;
        }
        if (other.checksum() != null && !other.checksum().equals(this.checksum())) {
            return false;
        }
        if (other.formatString() == null ^ this.formatString() == null) {
            return false;
        }
        if (other.formatString() != null && !other.formatString().equals(this.formatString())) {
            return false;
        }
        if (other.importManifestUrl() == null ^ this.importManifestUrl() == null) {
            return false;
        }
        if (other.importManifestUrl() != null && !other.importManifestUrl().equals(this.importManifestUrl())) {
            return false;
        }
        if (other.size() == null ^ this.size() == null) {
            return false;
        }
        return other.size() == null || other.size().equals(this.size());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.checksum() != null) {
            sb.append("Checksum: ").append(this.checksum()).append(",");
        }
        if (this.formatString() != null) {
            sb.append("Format: ").append(this.formatString()).append(",");
        }
        if (this.importManifestUrl() != null) {
            sb.append("ImportManifestUrl: ").append(this.importManifestUrl()).append(",");
        }
        if (this.size() != null) {
            sb.append("Size: ").append(this.size()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Checksum": {
                return Optional.of(clazz.cast(this.checksum()));
            }
            case "Format": {
                return Optional.of(clazz.cast(this.formatString()));
            }
            case "ImportManifestUrl": {
                return Optional.of(clazz.cast(this.importManifestUrl()));
            }
            case "Size": {
                return Optional.of(clazz.cast(this.size()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String checksum;
        private String format;
        private String importManifestUrl;
        private Long size;

        private BuilderImpl() {
        }

        private BuilderImpl(DiskImageDescription model) {
            this.checksum(model.checksum);
            this.format(model.format);
            this.importManifestUrl(model.importManifestUrl);
            this.size(model.size);
        }

        public final String getChecksum() {
            return this.checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(DiskImageFormat format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getImportManifestUrl() {
            return this.importManifestUrl;
        }

        @Override
        public final Builder importManifestUrl(String importManifestUrl) {
            this.importManifestUrl = importManifestUrl;
            return this;
        }

        public final void setImportManifestUrl(String importManifestUrl) {
            this.importManifestUrl = importManifestUrl;
        }

        public final Long getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        public DiskImageDescription build() {
            return new DiskImageDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DiskImageDescription> {
        public Builder checksum(String var1);

        public Builder format(String var1);

        public Builder format(DiskImageFormat var1);

        public Builder importManifestUrl(String var1);

        public Builder size(Long var1);
    }
}

